/* GNU OpenStep interface file for Responder class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Copyright (C) 1993 Keith Mason. All Rights Reserved
 *
 * Authors: Scott Francis, Paul Kunz, Keith Mason, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Responder.h,v 1.24 1994/06/15 18:58:28 pfkeb Exp
 */
 

#ifndef _GNUSTEP_APPKIT_RESPONDER_H_
#define _GNUSTEP_APPKIT_RESPONDER_H_

#include <objc/Object.h>

#include <dpsclient/event.h>
#include <objc2/hashtable.h>
#include <objc2/typedstream2.h>

#define MAX_WIDGETS 5
#define BASE 0

@interface Responder:Object
{
    id                  nextResponder;

/* Instance variables for the window system specific implementation */
    void               *classname;	/* that is the window class name */
    char               *instancename;	/* the Objective-C name */
    void               *widgetid;	/* widgetid of this responder */

/* These are for argument passing to widgets */
    void               *arglist;
    int                 numargs;
    int                 allocedargs;
}

- init;

// Freeing an instance
- free;

// Setting the next responder
- setNextResponder:aResponder;
- nextResponder;

// Determining the first responder
- (BOOL)acceptsFirstResponder;
- becomeFirstResponder;
- resignFirstResponder;

// Aiding event processing
- (BOOL)performKeyEquivalent:(NXEvent *)theEvent;
- (BOOL)tryToPerform:(SEL)anAction
    with:anObject;

// Forwarding event messages
- mouseDown:(NXEvent *)theEvent;
- rightMouseDown:(NXEvent *)theEvent;
- mouseDragged:(NXEvent *)theEvent;
- rightMouseDragged:(NXEvent *)theEvent;
- mouseUp:(NXEvent *)theEvent;
- rightMouseUp:(NXEvent *)theEvent;
- mouseMoved:(NXEvent *)theEvent;
- mouseEntered:(NXEvent *)theEvent;
- mouseExited:(NXEvent *)theEvent;
- keyDown:(NXEvent *)theEvent;
- keyUp:(NXEvent *)theEvent;
- flagsChanged:(NXEvent *)theEvent;
- noResponderFor:(const char *)eventType;

// Services menu support
- validRequestorForSendType:(NXAtom)typeSent
    andReturnType:(NXAtom)typeReturned;

// Help menu support
- helpRequested:(NXEvent *)eventPtr;

// Archiving
- read:(NXTypedStream *)stream;
- write:(NXTypedStream *)stream;
@end


/* Window system specific methods are in category */

@interface Responder(WidgetSet)
- _addArg:(const char *)name :(void *)value;
- _setArg:(const char *)name to:(void *)value;
- _getArg:(const char *)name into:(void *)value;
- (void *)_arglist;
- (int)_numargs;
- _setnumargs:(int)val;
@end


#endif  _GNUSTEP_APPKIT_RESPONDER_H_
