/* Interface for OpenPanel class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Jeff Kamerer
 *
 * This file is part of an Objective-C class library for a window system
 *
 */

#ifndef _OpenPanel_h_
#define _OpenPanel_h_

#include "SavePanel.h"

@interface OpenPanel : SavePanel
{
    char        **filterTypes;
    BOOL        _allowMultipleFiles;
}

- initContent:(const NXRect *)contentRect style:(int)aStyle
	backing:(int)backingType buttonMask:(int)mask defer:(BOOL)flag;
- ok:sender;

- allowMultipleFiles:(BOOL)flag;

- (int)runModalForDirectory:(const char *)path file:(const char *)name 
                      types:(const char *const *)fileTypes;
- (int)runModalForTypes:(const char *const *)fileTypes;
- (int)runModalForDirectory:(const char *)path file:(const char *)name;

@end

#endif  /* _OpenPanel_h_ */
