/* Interface for Menu class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library a window system
 *
 * Menu.h,v 1.23 1994/06/15 18:58:10 pfkeb Exp
 */

#ifndef _Menu_h_
#define _Menu_h_

#include "Panel.h"

@class List, Matrix, MenuCell;
@interface Menu:Panel
{
    Menu	*supermenu;
    Matrix	*matrix;
    MenuCell	*_helpSubmenu;
    
    BOOL autoUpdate;
}

// + setMenuZone:(NXZone *)aZone;
// + (NXZone *)menuZone;

- init;
- initTitle:(const char *)aTitle;

// - addItem:(const char *)aString action:(SEL)aSelector 
//   keyEquivalent:(unsigned short)charCode;
// - setSubmenu:aMenu forItem:aCell;
- itemList;
// - setItemList:aMatrix;
// - display;
// - sizeToFit;
// - moveTopLeftTo:(NXCoord)x :(NXCoord)y;
// - windowMoved:(NXEvent *)theEvent;
// - close;
- update;
- setAutoupdate:(BOOL)flag;
// - findCellWithTag:(int)aTag;
// - getLocation:(NXPoint *)theLocation forSubmenu:aSubmenu;
// - mouseDown:(NXEvent *)theEvent;
// - rightMouseDown:(NXEvent *)theEvent;
- awake;
// - write:(NXTypedStream *)stream;
// - read:(NXTypedStream *)stream;

// + new;
// + newTitle:(const char *)aTitle;

- free;
- addItem:(const char*)aString action:target sel:(SEL)aSelector;
- setSubmenu:aMenu forItem:(const char*)aString;
- setHelpSubmenu:aMenu;
- (BOOL)_isMain;
- _managedBy:parent;
- read:(TypedStream *)typedStream;

@end

// @interface Menu(SubmenuDummyAction)
// - submenuAction:sender;
// @end

@interface Menu(WidgetSet)
- _init;
- _managedBy:parent wid:(void*)widget;
@end


#endif /* _Menu_h_ */
