/* Implementation of  Control class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system.
 *
 * Control.m,v 1.53 1994/07/16 17:04:47 pfkeb Exp
 */

#include "Control.h"

#include "ActionCell.h"
#include "Application.h"
#include <stdio.h>

@implementation Control:View

// + setCellClass:factoryId;

- initFrame:(const NXRect *)frameRect
{
    [super initFrame:frameRect];
    [cell _setFrame:frameRect];
    if ( [cell respondsTo:@selector(_setControlView:)] ) {
        [(ActionCell *)cell _setControlView:self];
    }
    return self;
}

- moveTo:(NXCoord)x :(NXCoord)y
{
    frame.origin.x = x;
    frame.origin.y = y;
    bounds.origin.x = x;
    bounds.origin.y = y;
    /* assume that widget will be moved by the cell class 
     */
    if ( cell != 0 ) {
	[cell _moveTo:x :y];
    } else {
    	[super moveTo:x :y];
    }
    return self;
}

- free
{
    [cell free];
    return [super free];
}


// - sizeToFit;
// - sizeTo:(NXCoord)width :(NXCoord)height;
// - calcSize;

- cell
{
    return cell;
}

// - setCell:aCell;

- selectedCell
{
    return cell;
}

- target
{
    return [cell target];
}

- setTarget:anObject
{
    [cell setTarget:anObject];
    return self;
}

- (SEL)action
{
    return [cell action];
}

- setAction:(SEL)aSelector
{
    [cell setAction:aSelector];
    return self;
}

- (int)tag
{
    return [cell tag];
}

- setTag:(int)anInt
{
    return [cell setTag:anInt];
}

- (int)selectedTag
{
 /*
  * Matrix doesn't doesn't implement this method, thus we implement it here
  * in way that it will work for Matrix. 
  */
    return [[self selectedCell] tag];
}

// - ignoreMultiClick:(BOOL)flag;
// - mouseDown:(NXEvent *)theEvent;
// - (int)mouseDownFlags;
// - (int)sendActionOn:(int)mask;
// - (BOOL)isContinuous;
// - setContinuous:(BOOL)flag;

- (BOOL)isEnabled
{
    return [cell isEnabled];
}

- setEnabled:(BOOL)flag
{
    [cell setEnabled:flag];
    return self;
}

// - setFloatingPointFormat:(BOOL)autoRange left:(unsigned)leftDigits 
//                                         right:(unsigned)rightDigits;

- (int) alignment
{
    return [cell alignment];
}

- setAlignment:(int)mode
{
    [cell setAlignment:mode];
    return self;
}

// - font;
// - setFont:fontObj;
// - setStringValueNoCopy:(char *)aString shouldFree:(BOOL)flag;

- setStringValue:(const char *)aString
{
    [cell setStringValue:aString];
    return self;
}

// - setStringValueNoCopy:(const char *)aString;

- setIntValue:(int)anInt
{
    [cell setIntValue:anInt];
    return self;
}

- setFloatValue:(float)aFloat
{
    [cell setFloatValue:aFloat];
    return self;
}

- setDoubleValue:(double)aDouble
{
    [cell setDoubleValue:aDouble];
    return self;
}

- (const char *)stringValue
{
    return [cell stringValue];
}

- (int)intValue
{
    return [cell intValue];
}

- (float)floatValue
{
    return [cell floatValue];
}

- (double)doubleValue
{
    return [cell doubleValue];
}

// - update;
// - updateCell:aCell;
// - updateCellInside:aCell;
// - drawCellInside:aCell;
// - drawCell:aCell;

- selectCell:aCell
{
    return self;
}

// - drawSelf:(const NXRect *)rects :(int)rectCount;

- sendAction:(SEL)theAction to:theTarget
{
    if ( !theAction ) {
        return nil;	// a guess, documentation not clear
    }
    if ( [NXApp sendAction:theAction to:theTarget from:self] ) {
        return self;
    }
    return nil;
}

- takeIntValueFrom:sender
{
    [cell setIntValue:[sender intValue]];
    return self;
}

- takeFloatValueFrom:sender
{
    [cell setFloatValue:[sender floatValue]];
    return self;
}

- takeDoubleValueFrom:sender
{
    [cell setDoubleValue:[sender doubleValue]];
    return self;
}

- takeStringValueFrom:sender
{
    [cell setStringValue:[sender stringValue]];
    return self;
}

// - currentEditor;

- abortEditing
{
    return self;
}

// - validateEditing;
// - resetCursorRects;
// - write:(NXTypedStream *)stream;

- read:(TypedStream*)typedStream
{
    [super read:typedStream];
    objc_read_object(typedStream,&cell);
    return self;
}

+ newFrame:(const NXRect *)frameRect
{
     return [[super alloc] initFrame:frameRect];
}


/* Methods not in NeXTSTEP */

- sendAction
{
    if ( cell && [cell action] ) {
        if ( [cell target] ) {
	    [[cell target] perform:[cell action] with:self];
	} 
    }
    return self;
}

- setFrame:(const NXRect *)frameRect
{
  /* Not in OpenStep Control class */
    [super setFrame:frameRect];
    [cell _setFrame:frameRect];
    if ( [cell respondsTo:@selector(_setControlView:)] ) {
        [(ActionCell *)cell _setControlView:self];
    }
    return self;
}

- setIcon:(const char *)iconName
{
    return [cell setIcon:iconName];
}

- _managedBy:parent wid:(void*)widget
{
    if ( cell ) {
    	[cell _setFrame:&frame];
	if ( [cell respondsTo:@selector(_setControlView:)] ) {
	    [(ActionCell *)cell _setControlView:self];
	}
	[cell _managedBy:superview];
    } else {
	[super _managedBy:parent wid:widget];
    }
    return self;
}
- _destroy
{
    if ( cell ) {
	[cell _destroy];
    } else { 
    	[super _destroy];
    }
    return self;
}
    
@end
