/* Interface for Cell class
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Cell.h,v 1.44 1994/06/25 01:11:33 pfkeb Exp
 */

 
#ifndef _Cell_h_
#define _Cell_h_

#include <objc/Object.h>
#include "graphics.h"

@class Control;
@interface Cell:Object
{
    char               *contents;
    id                  support;

  /* The following are in struct cFlags1 in OpenStep */
    BOOL                state;
    BOOL                highlighted;
    BOOL		disabled;
    BOOL                editable;
    unsigned char       type;
    BOOL                freeText;
    unsigned char	alignment;	/* for sub-classes that can use it */
    BOOL                bordered;
    BOOL                bezeled;
    BOOL                selectable;
    BOOL                scrollable;
    unsigned char       entryType;

  /* The following in struct cFlags2 in OpenStep */
    BOOL                continous;
    BOOL                actOnMouseDown;
    BOOL		_isLeaf;
    unsigned char       floatLeft;
    unsigned char       floatRight;
    BOOL                autoRange;
    BOOL                actOnMouseDragged;
    BOOL		_isLoaded;
    BOOL                noWrap;
    BOOL                dontActOnMouseUp;

  /* The following in struct cFlags3 in OpenStep */
    BOOL                isWhite;
    BOOL                useUserKeyEquivalent;
    BOOL                center;
    BOOL                docEditing;
    BOOL                docSaved;
    BOOL                wasSelectable;

  /* These are for argument passing to widgets */
    char               *instancename;
    void               *classname;
    void               *widgetid;
    void               *arglist;
    int                 numargs;
    int                 allocedargs;
    Control		*parentid;
    NXRect		_frame;
}

// + (BOOL)prefersTrackingUntilMouseUp;

- init;
- initTextCell:(const char *)aString;
- initIconCell:(const char *)iconName;

// - copyFromZone:(NXZone *)zone;
// - awake;

- free;
- controlView;
- (int)type;
- setType:(int)aType;
- (int)state;
- setState:(int)value;

// - incrementState;

- target;
- setTarget:anObject;
- (SEL)action;
- setAction:(SEL)aSelector;
- (int)tag;
- setTag:(int)anInt;

// - (BOOL)isOpaque;

- (BOOL)isEnabled;
- setEnabled:(BOOL)flag;

// - (int)sendActionOn:(int)mask;
// - (BOOL)isContinuous;
// - setContinuous:(BOOL)flag;
// - (BOOL)isEditable;
// - setEditable:(BOOL)flag;
// - (BOOL)isSelectable;
// - setSelectable:(BOOL)flag;
// - (BOOL)isBordered;
// - setBordered:(BOOL)flag;
// - (BOOL)isBezeled;
// - setBezeled:(BOOL)flag;
// - (BOOL)isScrollable;
// - setScrollable:(BOOL)flag;
// - (BOOL)isHighlighted;

- (int)alignment;
- setAlignment:(int)mode;

// - setWrap:(BOOL)flag;
// - font;
// - setFont:fontObj;
// - (int)entryType;
// - setEntryType:(int)aType;
// - (BOOL)isEntryAcceptable:(const char *)aString;

- setFloatingPointFormat:(BOOL)autoRange 
                       left:(unsigned)leftDigits right:(unsigned)rightDigits;

// - (unsigned short)keyEquivalent;

- (const char *)stringValue;
- setStringValue:(const char *)aString;

// - setStringValueNoCopy:(const char *)aString;
// - setStringValueNoCopy:(char *)aString shouldFree:(BOOL)flag;

- (int)intValue;
- setIntValue:(int)anInt;
- (float)floatValue;
- setFloatValue:(float)aFloat;
- (double)doubleValue;
- setDoubleValue:(double)aDouble;
- takeIntValueFrom:sender;

// - takeFloatValueFrom:sender;
// - takeDoubleValueFrom:sender;

- takeStringValueFrom:sender;
- (const char *)icon;
- setIcon:(const char *)iconName;

// - (int)getParameter:(int)aParameter;
// - setParameter:(int)aParameter to:(int)value;
// - getIconRect:(NXRect *)theRect;
// - getTitleRect:(NXRect *)theRect;
// - getDrawRect:(NXRect *)theRect;
// - calcCellSize:(NXSize *)theSize;
// - calcCellSize:(NXSize *)theSize inRect:(const NXRect *)aRect;
// - calcDrawInfo:(const NXRect *)aRect;
// - setTextAttributes:textObj;
// - drawInside:(const NXRect *)cellFrame inView:controlView;
// - drawSelf:(const NXRect *)cellFrame inView:controlView;
// - highlight:(const NXRect *)cellFrame inView:controlView lit:(BOOL)flag;
// - (int)mouseDownFlags;
// - getPeriodicDelay:(float*)delay andInterval:(float*)interval;
// - (BOOL)startTrackingAt:(const NXPoint *)startPoint inView:controlView;
// - (BOOL)continueTracking:(const NXPoint *)lastPoint 
//                       at:(const NXPoint *)currentPoint inView:controlView;
// - stopTracking:(const NXPoint *)lastPoint at:(const NXPoint *)stopPoint 
//         inView:controlView mouseIsUp:(BOOL)flag;
// - (BOOL)trackMouse:(NXEvent *)theEvent inRect:(const NXRect *)cellFrame 
//             ofView:controlView;
// - edit:(const NXRect *)aRect inView:controlView editor:textObj 
//   delegate:anObject event:(NXEvent *)theEvent;
// - select:(const NXRect *)aRect inView:controlView editor:textObj 
//               delegate:anObject start:(int)selStart length:(int)selLength;
// - endEditing:textObj;
// - write:(NXTypedStream *)stream;

- read:(NXTypedStream *)stream;

// - resetCursorRect:(const NXRect *)cellFrame inView:controlView;

// + new; 
// + newTextCell; 
// + newTextCell:(const char *)aString; 
// + newIconCell; 
// + newIconCell:(const char *)iconName;

- copy;
- sendAction;
@end

// #ifdef KANJI
// @interface Cell(InputManager)
// - (BOOL)cellUsesIM;
// - setCellUsesIM:(BOOL)flag;
// @end
// #endif



@interface Cell(WidgetSet)
/* The following methods are GNUStep only */
- _moveTo:(NXCoord)x :(NXCoord)y;
- _setEnabled:(BOOL)flag;
- _setFrame:(const NXRect *)frame;
- _getFrame:(NXRect *)frame;
- _setSize:(const NXSize *)size;
- _addArg:(const char *)name :(void *)value;
- _setArg:(const char *)name to:(void*)value;
- _getArg:(const char *)name into:(void*)value;
- _addCallback;
- _managedBy:parent;
- _managedBy:parent wid:(void *)widget;
- _destroy;
- (void *)_widget;
@end

#endif
