/* Interface for ButtonCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Imran Qureshi,
 * and Libing Wang.
 *
 * This file is part of an Objective-C class library for a window system
 *
 * ButtonCell.h,v 1.32 1994/06/15 18:57:31 pfkeb Exp
 */

 
#ifndef _ButtonCell_h_
#define _ButtonCell_h_

#include "ActionCell.h"
#include "sysparams.h"

#define NXBUTTON 0
#define NXRADIO 1
#define NXSWITCH 2

@interface ButtonCell:ActionCell
{
    int 	popup;	/* is this a popupshell buttoncell */
    char	*altContents;
    char	*icon;
    char	*altIcon;
    char        *iconFile;
    char	*altIconFile;
    int		widgetType;  /* 0=button, 1=NXRadio, 2=NXSwitch */
    int		radioBehavior;
    unsigned long	backgroundColor;
    unsigned short	keyEquivalent;
}

- init;
- copy;
- setIcon:(const char *)iconName;
- (const char *)icon;
- setTitle:(const char *)aString;
- (const char *)title;
- setKeyEquivalent:(unsigned short)charCode;
- _setMode:(int)aMode;
- setState:(int)value;
- performClick:sender;
- read:(TypedStream*)typedStream;
- (int)_radioType;
@end

@interface ButtonCell(WidgetSet)
- _init;
- _setStringValue:(const char *)aString;
- _setState:(int)value;
- _setPopUp;
- _addCallback;
- _managedBy:parent;
@end

#endif
