/*  Archiving Category for View
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmView.m,v 1.17 1994/06/11 03:54:10 pfkeb Exp

*/

#include "XmView.h"
#include <stdio.h>
#include <stdlib.h>

/* This brings definition of objc_write_float,objc_write_rect */
#include "archive-def.h"


@implementation View (XmArchiving)
-convertCoordToMotif:sender
{
    NXRect              superview_frame;

 /* if this message is straight from archiver, forget it */
 /* Only a message passed down from a window should be acted on */
    if (!sender)
	return self;

    if ([superview isFlipped]) {
#ifdef DEBUG
	printf("I'm already flipped \n");
#endif
    } else {
	[superview getFrame:&superview_frame];
#ifdef DEBUG
	printf("%s: y-origin from %f ", [self name], frame.origin.y);
#endif
	frame.origin.y = superview_frame.size.height 
	                 - frame.origin.y - frame.size.height;
#ifdef DEBUG
	printf("to %f\n", frame.origin.y);
#endif
    }
    [subviews makeObjectsPerform:@selector(convertCoordToMotif:) with :self];
    return self;
}

- write:(TypedStream *)stream
{
    int		count;

    [super write:stream];

    objc_write_rect(stream, &frame);

 /* Now write out the subviews */

    count = [subviews count];

#ifdef DEBUG
    if ( count )
    	printf("->(View with %d subviews)", count);
    else
    	printf("->View");
#endif

    objc_write_object(stream,subviews);

    return self;
}
@end
