/*  Archiving Category for TextField
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Scott Francis, Paul Kunz, and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmTextField.m,v 1.10 1994/06/11 03:54:05 pfkeb Exp

*/

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"

#include "XmControl.h"
#include <appkit/TextField.h>


@interface TextField (XmArchiving)
- convertCoordToMotif:sender;
- write:(TypedStream *)stream;
@end

@implementation TextField (XmArchiving)
- convertCoordToMotif:sender
{
    [super convertCoordToMotif:sender];
 /* adjust dimensions so that un-selected widget is same as NeXT object */
    frame.origin.x    -= 2;
    frame.origin.y    -= 2;
    frame.size.height += 4;
    frame.size.width  += 4;
    return self;
}

- write:(TypedStream *)stream
{
    int                 a, b, c, d;

    [super write:stream];

#ifdef DEBUG
    printf("\n->TextField");
#endif
    a = [self isEditable];
    b = [self isSelectable];
    c = [self isBezeled];
    d = [self isBordered];
    objc_write_types(stream, "iiii", &a, &b, &c, &d);

    return self;
}

- setTextDelegate:anObject
{
#ifdef DEBUG
    printf(" connecting delegate as %p for %p\n", anObject, self);
#endif
    textDelegate = anObject;
    return self;

}
@end
