/*  Archiving Category for CustomObject
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

 * This file is part of the nib translator for 
 * an Objective-C class library for X/Motif

XmCustomObject.h,v 1.4 1994/06/11 03:53:26 pfkeb Exp

*/

#ifndef _XM_CUSTOM_OBJC_
#define _XM_CUSTOM_OBJC_

#include "/NextDeveloper/Headers/objc/typedstream.h"
#include "/NextDeveloper/Headers/objc/Object.h"
#include <apps/InterfaceBuilder.h>

/* This are interfaces for NeXT Custom Objects */

@interface CustomObject:Object
{
  char	*className;
  id    realObject;
  id    extension;
}
- free;
- write:(NXTypedStream *) s;
- read:(NXTypedStream *) s;
- init;
- awake;
- nibInstantiate;

@end


/* And now the category additions */

@interface CustomObject (XmArchiving)
- init;
- free;
- nibInstantiate;
- write:(TypedStream *)stream;

@end

#endif	/* _XM_CUSTOM_OBJC_ */

