/*  nib translator class
    Copyright (C)  1993  The Board of Trustees of
    The Leland Stanford Junior University.  All Rights Reserved.

Authors: Paul Kunz and Imran Qureshi

This file is part of the nib translator for 
an Objective-C class library for X/Motif

Translator.m,v 1.5 1994/06/16 00:20:53 pfkeb Exp

*/

#include "Translator.h"

#include <stdio.h>
#include "XmWindow.h"

/*
 * We can't include <appkit/Application.h> because it leads to
 * conflicts in definition of object structure.   So we duplicate
 * the minimum we need below to gain access to to Application object 
 * and avoid warning messages.
 */
extern id 	NXApp;
@interface Translator(Application)
- loadNibFile:(const char *) filename owner:anObject;
@end

List	*list_of_objects;	/* Global List of objects */
List	*list_of_connections;	/* Global list of connections */

/* Boolean for whether FileOwner's CustomObject has already been added
 * to the list */
BOOL		fileOwnerAdded;


@implementation Translator

- translate:(const char *)nibfile into:(char *)filename
{
    TypedStream        *typedStream;
    id                  res;

#ifdef DEBUG
    printf("Starting translation...\n");
#endif

    fileOwnerAdded = NO;
    list_of_objects = [[List alloc] init];
    list_of_connections = [[List alloc] init];

#ifdef DEBUG
    printf("\nReading nib file\n");
#endif

    res = [NXApp loadNibFile:nibfile owner:self];
    
#ifdef DEBUG
    printf("result = %p\n", res);
    [self printList];
#endif

    if (filename) {
	typedStream = objc_open_typed_stream_for_file(filename,
						      OBJC_WRITEONLY);
    } else {
	return nil;
    }

 /* Now flip the coordinates */
    [self convertCoordToMotif:list_of_objects];

    [list_of_objects addObject:list_of_connections];
    
#ifdef DEBUG
    printf("\nStarting to write...");
#endif

    objc_write_root_object(typedStream, list_of_objects);

#ifdef DEBUG
    printf("\nfinished writing.\n");
#endif

    objc_flush_typed_stream(typedStream);
    objc_close_typed_stream(typedStream);

    fflush(stdout);

    return self;
}

-printList
{
    int                 i, count;

    printf( "\nList of objects read...\n");
    count = [list_of_objects count];
    for (i = 0; i < count; i++) {
	printf("Object #%d is %s\n", i, [[list_of_objects objectAt:i] name]);
    }
    return self;
}
-convertCoordToMotif:list
{
    id                  anObject;
    int                 i, count;

#ifdef DEBUG
    printf("\nConverting coords to Motif...\n");
#endif
    
    count = [list count];
    for (i = 0; i < count; i++) {
        anObject = [list_of_objects objectAt:i];
#ifdef DEBUG
	printf("Object #%d is a %s\n", i, [anObject name]);
#endif
	if ([anObject respondsTo:@selector(convertCoordToMotif:)])
	    [anObject perform:@selector(convertCoordToMotif:) with :NULL];
    }
#ifdef DEBUG
    printf("done with conversion \n");
#endif
    return self;
}
@end
