/* Controller for PopUpList tests
 * by Paul Kunz		September 1993
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 */
 
#include "Controller.h"

#import <appkit/Button.h>
#import <appkit/Form.h>
#import <appkit/Matrix.h>
#import <appkit/PopUpList.h>

@implementation Controller

- appDidInit:sender
{
    popUpList = [popUpButton target];
    [popUpList setTarget:self];
    [popUpList setAction:@selector(popUped:)];
    [self updateForm];
    [testWindow setDelegate:self];
    return self;
}
- popUped:sender
{
    Matrix	*matrix;
    
    matrix = [popUpList itemList];
    if ( matrix != sender ) {
        printf( "sender is not PopUpList's matrix\n");
    }

    [self updateForm];
    return self;
}

- testAddItem:sender
{
    const char	*title;
    
    title = [testParmsForm stringValueAt:0];
    [popUpList addItem:title];
    return self;
}

- testIndexOfItem:sender
{
    const char	*title;
    int		index;
    
    title = [testParmsForm stringValueAt:0];
    index = [popUpList indexOfItem:title];
    [testParmsForm setIntValue:index at:1];
    return self;
}

- testInsertItem:sender
{
    const char	*title;
    int		index;
    
    title = [testParmsForm stringValueAt:0];
    index = [testParmsForm intValueAt:1];
    [popUpList insertItem:title at:index];
    [self updateForm];
    return self;
}

- testRemoveItem:sender
{
    int		index;
    
    index = [testParmsForm intValueAt:1];
    [popUpList removeItemAt:index];
#ifdef __NeXT__
    NXPing();
#endif
    [self updateForm];
    return self;
}

- updateForm
{
    Matrix	*matrix;
    int		row;
    
    matrix = [popUpList itemList];
    row = [matrix selectedRow];
    [selCellForm setIntValue:row];
    return self;
}

- windowDidBecomeMain:sender
{
    [self updateForm];
    return self;
}

@end
