/* Implementation for Objective-C String object
   Copyright (C) 1993 Free Software Foundation, Inc.

   Written by:  R. Andrew McCallum <mccallum@cs.rochester.edu>
   Dept. of Computer Science, U. of Rochester, Rochester, NY  14627

   This file is part of the GNU Objective-C Collection library.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

/* WARNING:  This implementation is incomplete and preliminary.  
   I'm just trying to get a 
   feel for how Strings will fit together with IndexedCollection. 
   cheng@iesd.auc.dk may be working on a String heirarchy.
   */

#include <coll/String.h>
#include <coll/IndexedCollectionPrivate.h>
/* memcpy(), strlen(), strcmp() are gcc builtin's */

@implementation String

+ initialize
{
  if (self == [String class])
    [self setVersion:-1];	/* alpha release */
  return self;
}

// INITIALIZING;

/* This is the designated initializer for this class */
- initFromCString: (char*)aCharPtr range: (IndexRange)aRange
{
  [super initEncoding:@encode(char)];
  _count = aRange.end - aRange.start;
  OBJC_MALLOC(_contents_chars, char, _count+1);
  memcpy(_contents_chars, aCharPtr + aRange.start, _count);
  _contents_chars[_count] = '\0';
  return self;
}

#warning: many methods in String not implemented

- write: (TypedStream*)aStream
{
  // archive inst vars;
  [self notImplemented:_cmd];
  [super write:aStream];
  return self;
}

- read: (TypedStream*)aStream
{
  // archive inst vars;
  [self notImplemented:_cmd];
  [super read:aStream];
  return self;
}

/* Empty copy must empty an allocCopy'ed version of self */
- emptyCopy
{
  String *copy = [super emptyCopy];
  OBJC_MALLOC(copy->_contents_chars, char, _count+1);
  copy->_count = 0;
  copy->_contents_chars[_count] = '\0';
  return copy;
}

/* This must work without sending any messages to content objects */
- empty
{
  _count = 0;
  _contents_chars[_count] = '\0';
  return self;
}

/* Override the designated initializer of superclass */
- initEncoding: (const char *)contentEncoding
{
  if (strcmp(contentEncoding, @encode(char)))
    [self error:"invalid args to String initializer"];
  [self init];
  return self;
}

- initFromCString: (char*)aCharPtr length: (unsigned)aLength
{
  return [self initFromCString:aCharPtr 
	       range:((IndexRange){0,aLength})];
}

- initFromCString: (char*)aCharPtr
{
  return [self initFromCString:aCharPtr
	       range:((IndexRange){0, strlen(aCharPtr)})];
}

- initFromCFormat: (char*)formatCharPtr, ...
{
  return [self notImplemented:_cmd];
}

- initFromFormat: (String*)aFormatString withArgList: (va_list)arg
{
  return [self notImplemented:_cmd];
}

- init
{
  return [self initFromCString:""];
}

- initFromString: (String*)aString range: (IndexRange)aRange
{
  return [self notImplemented:_cmd];
}

- initFromString: (String*)aString length: (unsigned)aLength
{
  return [self notImplemented:_cmd];
}

- initFromString: (String*)aString
{
  return [self notImplemented:_cmd];
}

- initFromFormat: (String*)aFormatString, ...
{
  return [self notImplemented:_cmd];
}

- initFromCFormat: (char*)formatCharPtr withArgList: (va_list)arg
{
  return [self notImplemented:_cmd];
}


// COPYING;

- (char *) cStringCopyRange: (IndexRange)aRange;
{
  char *ret;
  int len = aRange.end - aRange.start;

  // need to check aRange for errors;
  OBJC_MALLOC(ret, char, len + 1);
  memcpy(ret, _contents_chars, len);
  ret[len] = '\0';
  return ret;
}

- (char *) cStringCopyLength: (unsigned)aLength
{
  // need to check aLength against _count;
  return [self cStringCopyRange:((IndexRange){0,aLength})];
}

- (char *) cStringCopy
{
  return [self cStringCopyRange:((IndexRange){0,_count})];
}

- setCString: (char *)buffer range: (IndexRange)aRange
{
  return [self notImplemented:_cmd];
}
  
- setCString: (char *)buffer length: (unsigned)aLength
{
  return [self notImplemented:_cmd];
}

- setCString: (char *)buffer
{
  return [self notImplemented:_cmd];
}


// REPLACING;

- replaceAllStrings: (String*)oldString with: (String*)newString
{
  return [self notImplemented:_cmd];
}

- replaceFirstString: (String*)oldString with: (String*)newString
{
  return [self notImplemented:_cmd];
}

- replaceFirstString: (String*)oldString 
    afterIndex: (unsigned)index 
    with: (String*)newString
{
  return [self notImplemented:_cmd];
}

- setToAllCapitals
{
  return [self notImplemented:_cmd];
}

- setToInitialCapitals
{
  return [self notImplemented:_cmd];
}

- setToLowerCase
{
  return [self notImplemented:_cmd];
}

- trimBlanks
{
  return [self notImplemented:_cmd];
}


// TESTING;

- (const char *) contentsDescription
{
  return @encode(char);
}

- (int(*)(elt,elt)) comparisonFunction
{
  return elt_compare_chars;
}

- (BOOL) isEqual: anObject 
{
    if (self == anObject) 
      return YES;
    if (! [anObject isKindOf:[String class]]
	|| [self count] != [anObject count]
	|| [anObject hash] != [self hash] ) 
      return NO;
    return ! [self compare:anObject ignoreCase:NO];
}    

- (unsigned) hash
{
  [self notImplemented:_cmd];
  return 0;
}

- (int) compare: anObject ignoreCase: (BOOL)flag
{
  [self notImplemented:_cmd];
  return 0;
}

- (int) compare: anObject
{
  [self notImplemented:_cmd];
  return 0;
}

- (unsigned) count
{
  return _count;
}

- copy
{
  return [self notImplemented:_cmd];
}

- (IndexRange) stringRange
{
  IndexRange r;
  [self notImplemented:_cmd];
  return r;
}

- (unsigned) indexOfChar: (char)aChar ignoreCase: (BOOL)flag
{
  [self notImplemented:_cmd];
  return 0;
}

- (unsigned) indexOfChar: (char)aChar
{
  [self notImplemented:_cmd];
  return 0;
}

- (unsigned) indexOfLastChar: (char)aChar ignoreCase: (BOOL)flag
{
  [self notImplemented:_cmd];
  return 0;
}

- (unsigned) indexOfLastChar: (char)aChar
{
  [self notImplemented:_cmd];
  return 0;
}

- (unsigned) indexOfString: (String*)aString ignoreCase: (BOOL)flag
{
  [self notImplemented:_cmd];
  return 0;
}

- (unsigned) indexOfString: (String*)aString
{
  [self notImplemented:_cmd];
  return 0;
}

- (char) charAtIndex: (unsigned)index
{
  CHECK_INDEX_RANGE_ERROR(index, _count);
  return _contents_chars[index];
}



// GETTING VALUES;

- (int) intValue
{
  [self notImplemented:_cmd];
  return 0;
  //  return atoi(_contents_chars);
}

- (float) floatValue
{
  [self notImplemented:_cmd];
  return 0;
  //  return (float) atof(_contents_chars);
}

- (double) doubleValue
{
  return atof(_contents_chars);
}

- (const char *) cStringValue
{
  return _contents_chars;
}

- (String *) stringValue
{
  return self;
}

// SETTING VALUES;

- setIntValue: (int)anInt
{
  return [self notImplemented:_cmd];
}

- setFloatValue: (float)aFloat
{
  return [self notImplemented:_cmd];
}

- setDoubleValue: (double)aDouble
{
  return [self notImplemented:_cmd];
}

- setCStringValue: (const char *)aCString
{
  return [self notImplemented:_cmd];
}

- setStringValue: (String*)aString
{
  return [self notImplemented:_cmd];
}



// FOR FILE AND PATH NAMES;

- (IndexRange) fileRange
{
  IndexRange r;
  [self notImplemented:_cmd];
  return r;
}

- (IndexRange) pathRange
{
  IndexRange r;
  [self notImplemented:_cmd];
  return r;
}

- (IndexRange) extensionRange
{
  IndexRange r;
  [self notImplemented:_cmd];
  return r;
}

- (IndexRange) fileWithOutExtentionRange
{
  IndexRange r;
  [self notImplemented:_cmd];
  return r;
}

- (BOOL) isAbsolute
{
  [self notImplemented:_cmd];
  return NO;
}

- (BOOL) isRelative
{
  [self notImplemented:_cmd];
  return NO;
}


// FOR IndexedCollection SUPPORT;

static inline void
stringIncrementCountAndMakeHoleAt(String *self, unsigned index)
{
#ifndef STABLE_MEMCPY
  {
    int i;
    for (i = self->_count; i >= index; i--)
      self->_contents_chars[i+1] = self->_contents_chars[i];
  }
#else
  memcpy(self->_contents_chars + index, 
	 self->_contents_chars + index + 1, 
	 self->_count - index);
#endif /* STABLE_MEMCPY */
  (self->_count)++;
}

static inline void
stringDecrementCountAndFillHoleAt(String *self, unsigned index)
{
  (self->_count)--;
#ifndef STABLE_MEMCPY
  {
    int i;
    for (i = index; i <= self->_count; i++)
      self->_contents_chars[i] = self->_contents_chars[i+1];
  }
#else
  memcpy(self->_contents_chars + index + 1, 
	 self->_contents_chars + index, 
	 self->_count - index);
#endif /* STABLE_MEMCPY */
}

- insertElement: (elt)newElement atIndex: (unsigned)index
{
  CHECK_INDEX_RANGE_ERROR(index, _count+1);
  // one for the next char, one for the '\0';
  OBJC_REALLOC(_contents_chars, char, _count+1+1);
  stringIncrementCountAndMakeHoleAt(self, index);
  _contents_chars[index] = newElement.char_u;
  _contents_chars[_count] = '\0';
  return self;
}

- (elt) removeElementAtIndex: (unsigned)index
{
  elt ret;

  CHECK_INDEX_RANGE_ERROR(index, _count);
  ret = _contents_chars[index];
  stringDecrementCountAndFillHoleAt(self, index);
  //  OBJC_REALLOC(_contents_chars, char, _count);
  _contents_chars[_count] = '\0';
  return ret;
}

- (elt) elementAtIndex: (unsigned)index
{
  elt ret_elt;
  CHECK_INDEX_RANGE_ERROR(index, _count);
  ret_elt.char_u = _contents_chars[index];
  return ret_elt;
}

@end
