/* WidgetSet category for implementation of ButtonCell class
 *
 * Copyright (C)  1994  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Fred Harris, Paul Kunz, Imran Qureshi, 
 *          and Libing Wang (SLAC)
 *          Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for X/Motif
 *
 * xmButtonCell.m,v 1.3 1994/06/11 03:57:54 pfkeb Exp
 */

#include "ButtonCell.h"

#include "Application.h"
#include "Control.h"
#include "Window.h"
#include <stdlib.h>
#include <string.h>

#include "Motif.h"
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

char	*ButtonCellInstanceName( void )
{
    return "ButtonCell";
}

static void
thePushCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
   ButtonCell                 *butid = (ButtonCell*) client_data;
   XmPushButtonCallbackStruct *cb   = (XmPushButtonCallbackStruct *) call_data;

   switch (cb->reason) {
   case XmCR_ACTIVATE:
	break;
   case XmCR_ARM:
	[butid setState:1];
	break;
   case XmCR_DISARM:
	[butid sendAction];
        if ( ![butid _radioType] ) {
	    [butid setState:0];
	}
	break;
   default:
   }
   return;
}

static void
theToggleCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
   ButtonCell                 	*butid = (ButtonCell*) client_data;
   XmToggleButtonCallbackStruct *cb 
           = (XmToggleButtonCallbackStruct *) call_data;
   Boolean		value;

   switch (cb->reason) {
   case XmCR_VALUE_CHANGED:
	XtVaGetValues(w, XmNset, &value, NULL);
	if ([butid _radioType] == 1) {	/* If radio already set, do nothing */
	    if (!value) {		/* We just turned it off, so */
		value = 1;		/* turn it back on again  */
		XtVaSetValues(w, XmNset, value, NULL);
		return;
	    }
	}
	if (value) [butid setState:1];
	else [butid setState:0];
	[butid sendAction];
	break;
   default:
   }
   return;
}

static Pixel
highlightColor( void )
{
    Display	*disp = [NXApp _X_display];
    return  XWhitePixel(disp, XDefaultScreen(disp) );
}

@implementation ButtonCell(WidgetSet)

/* initialization */

- _init
{
    if (widgetType == NXBUTTON) {
    	classname = xmPushButtonWidgetClass;
    } else {
    	classname = xmToggleButtonGadgetClass;
    }
    return self;
}

- _setStringValue:(const char *)aString
{
    XmString xstring;
    xstring = XmStringCreateLtoR(contents, XmSTRING_DEFAULT_CHARSET);
    [self _setArg:XmNlabelString to:xstring];
    return self;
}

- _setState:(int)value
{
    Pixel               white;
    Boolean             localState;

    white = highlightColor();
    if (widgetType == NXBUTTON) {
	if (value) {
	    XtVaSetValues(widgetid, XmNbackground, white, NULL);
	} else {
	    XtVaSetValues(widgetid, XmNbackground, backgroundColor, NULL);
	}
    } else {
	localState = (value) ? True : False;
	XtVaSetValues(widgetid, XmNset, localState, NULL);
    }
    return self;
}

- _setPopUp
{
    [self _setArg:XmNlabelType to:(void *)XmSTRING];
    
    /* DO NOT CALL [self setStringValue:] */
    [self _setStringValue:contents];
    
    if (widgetType == NXBUTTON) {
	if(icon) [self _setArg:XmNlabelType to:(void *)XmPIXMAP];
    }
    return self;
}

- _addCallback
{
    if (widgetType == NXBUTTON) {
	XtAddCallback(widgetid, XmNactivateCallback, thePushCallback, self);
	XtAddCallback(widgetid, XmNarmCallback, thePushCallback, self);
	XtAddCallback(widgetid, XmNdisarmCallback, thePushCallback, self);
    } else {
	XtAddCallback(widgetid, XmNvalueChangedCallback, 
				theToggleCallback, self);
    }
    return self;
}

- _managedBy:parent
{
    Pixmap              pixmap;
    Pixel               white, foreground, background;
    void               *toplevel;

    switch ( widgetType ) {
    	case NXRADIO :
	    [self _addArg:XmNindicatorType :(void *)XmONE_OF_MANY ];
	    break;
	case NXSWITCH :
	    [self _addArg:XmNindicatorType :(void *)XmN_OF_MANY ];
	    break;
	default:
    }
    if (widgetType != NXBUTTON) {
    	classname = xmToggleButtonGadgetClass;
    }
    [super _managedBy:parent];
    if (widgetType == NXBUTTON) {
        white = highlightColor();
	[self _setArg:XmNarmColor to:(void *)white];
	toplevel = [[controlView window] _widget];
	XtVaGetValues(toplevel,XmNbackground, &backgroundColor, NULL);
	if (icon) {
	    toplevel = [[parent window] _shell];
	    XtVaGetValues(toplevel, XmNforeground, &foreground,
			  XmNbackground, &background, NULL);
	    foreground = BlackPixelOfScreen(XtScreen(toplevel));
	    pixmap = XmGetPixmap(XtScreen(toplevel),
				 iconFile, foreground, background);
	    [self _setArg:XmNarmPixmap to:(void *)pixmap];
	}
    }
    [self setState:[self state]];
    parentid = parent;
    return self;
}

@end
