/*   
 * graphics.h -- Emulation of NeXTStep's basic graphic objects
 * 
 * graphics.h,v 1.17 1994/06/11 03:57:39 pfkeb Exp
 * 
 * Copyright (C)  1994  The Board of Trustees of The Leland Stanford
 *                      Junior University.  All Rights Reserved.
 * 
 * Authors: Scott Francis, Paul Kunz, and Tom Pavel (SLAC) and
 *	    Adam Fedor (Univesity of Colorado)
 *
 */

#ifndef GRAPHICS_H
#define GRAPHICS_H

#include <objc/objc.h>
#include <objc2/typedstream2.h>
#include <dpsclient/event.h>

typedef struct _NXRect {
    NXPoint         origin;
    NXSize          size;
} NXRect;


#define	NX_X(aRect)	((aRect)->origin.x)
#define	NX_Y(aRect)	((aRect)->origin.y)
#define	NX_WIDTH(aRect)	((aRect)->size.width)
#define	NX_HEIGHT(aRect)	((aRect)->size.height)
#define	NX_MAXX(aRect)	((aRect)->origin.x + (aRect)->size.width)
#define	NX_MAXY(aRect)	((aRect)->origin.y + (aRect)->size.height)
#define	NX_MIDX(aRect)	(NX_X(aRect)+NX_WIDTH(aRect)/2.0)
#define	NX_MIDY(aRect)	(NX_Y(aRect)+NX_HEIGHT(aRect)/2.0)

#define	NX_WHITE	0xffffff
#define	NX_LTGRAY	0xaaaaaa
#define	NX_DKGRAY	0x555555
#define	NX_BLACK	0x000000

#define NX_XMIN		0
#define NX_YMIN		1
#define NX_XMAX		2
#define NX_YMAX		3

/*
 * The following values should be used in describing color space of bitmaps.
 */
typedef enum _NXColorSpace { 
    NX_CustomColorSpace = -1,           /* color space from graphics state */
    NX_OneIsBlackColorSpace = 0,        /* monochrome, 1 is black */
    NX_OneIsWhiteColorSpace = 1,        /* monochrome, 1 is white */
    NX_RGBColorSpace = 2,                       
    NX_CMYKColorSpace = 5
} NXColorSpace;

/*
 * NXWindowDepth defines the values used in setting window depth limits.
 * Use the functions NXBPSFromDepth() and NXColorSpaceFromDepth()
 * to extract colorspace/bps info from an NXWindowDepth.
 */
typedef enum _NXWindowDepth {
    NX_DefaultDepth = 0,
    NX_TwoBitGrayDepth = 258,
    NX_EightBitGrayDepth = 264,
    NX_TwelveBitRGBDepth = 516,
    NX_TwentyFourBitRGBDepth = 520
} NXWindowDepth;

/*	Rectangle functions         */

extern void XPing(void);
void NXSetRect(NXRect *aRect, NXCoord x, NXCoord y, 
              NXCoord width, NXCoord height);
void NXOffsetRect(NXRect *aRect, NXCoord dx, NXCoord dy);
extern void NXInsetRect(NXRect *aRect, NXCoord dX, NXCoord dY);
extern void NXIntegralRect(NXRect *aRect);
extern NXRect *NXUnionRect(const NXRect *aRect, NXRect *bRect);
BOOL NXMouseInRect(const NXPoint *aPoint, const NXRect *aRect, BOOL flipped);
BOOL NXPointInRect(const NXPoint *aPoint, const NXRect *aRect);
BOOL NXIntersectsRect(const NXRect *aRect, const NXRect *bRect);
BOOL NXContainsRect(const NXRect *aRect, const NXRect *bRect);
BOOL NXEqualRect(const NXRect *aRect, const NXRect *bRect);
BOOL NXEmptyRect(const NXRect *aRect);
NXRect *NXDivideRect(NXRect *aRect, NXRect *bRect, NXCoord slice, int edge);
extern NXRect *NXIntersectionRect(const NXRect *aRect, NXRect *bRect);

/* Color/Graphics functions */
extern NXColorSpace NXColorSpaceFromDepth (NXWindowDepth depth);
extern int NXBPSFromDepth (NXWindowDepth depth);
extern int NXNumberOfColorComponents (NXColorSpace colorSpace);
extern BOOL NXGetBestDepth (NXWindowDepth *depth, int numColors, int bps);

/* Archiving functions */
extern void NXReadRect(NXTypedStream *s, NXRect *aRect);
 
#endif GRAPHICS_H
