/* Interface for TextFieldCell class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * TextFieldCell.h,v 1.13 1994/06/15 18:58:40 pfkeb Exp
 */
 
#ifndef _TextFieldCell_h_
#define _TextFieldCell_h_

#include "ActionCell.h"

@interface TextFieldCell:ActionCell
{
    BOOL	_isLabel;	/* label or text field widget */
}
- init;
- copy;
- read:(TypedStream*)typedStream;
- write:(TypedStream*)typedStream;
- (const char *)stringValue;
- setStringValue:(const char *)aString;
- setTextGray:(float)value;
@end

@interface TextFieldCell(WidgetSet)
- _init;
- _initAsLabel;
- (const char *)_stringValue;
- _setStringValue;
@end

#endif
