/* Interface for SliderCell class
 *
 * Copyright (C)  1993  The Board of Trustees of
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * SliderCell.h,v 1.14 1994/06/15 18:58:37 pfkeb Exp
 */

#ifndef _Slidercell_h_
#define _Slidercell_h_

#include "ActionCell.h"

@interface SliderCell : ActionCell
{
	double 	maxValue;
	double  minValue;
	double  value;
	int	vert;	// vertical or not... for archiving
}

- init;
- copy;
- (double)minValue;
- setMinValue:(double)aDouble;
- (double)maxValue;
- setMaxValue:(double)aDouble;
- setDoubleValue:(double)aDouble;
- (double)doubleValue;
- setFloatValue:(float)aFloat;
- (float)floatValue;
- setIntValue:(int)anInt;
- (int)intValue;
- setStringValue:(const char *)str;
- (const char *)stringValue;
- (BOOL)isVertical;
- read:(TypedStream *)ts;
// in category - write:(TypedStream *)ts;

/* non-NeXTSTEP method */
- setVertical:(BOOL)flag;

@end

#endif
