/* Implementation for Slider class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Tom Pavel, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * Slider.m,v 1.21 1994/06/14 22:32:44 pfkeb Exp
 */

#include "Slider.h"

/* Required for implementation: */
#include "SliderCell.h"
#include <stdlib.h>

@implementation Slider


- initFrame:(const NXRect *)frameRect
{
    [super initFrame:frameRect];
    if (!cell) {
	cell = [[SliderCell alloc] init];
    }
    if (frame.size.width < frame.size.height) {
	[(SliderCell *)cell setVertical:YES];
    } else {
	[(SliderCell *)cell setVertical:NO];
    }
    return self;
}

- setTitle:(const char*)aString
{
    [cell setStringValue:aString];
    return self;
}

- (double) minValue
{
    return [(SliderCell *)cell minValue];
}

- setMinValue:(double)aDouble
{
    [(SliderCell *)cell setMinValue:aDouble];

    return self;
}

- (double)maxValue
{
    return [(SliderCell *)cell maxValue];
}

- setMaxValue:(double)aDouble
{
    [(SliderCell *)cell setMaxValue:aDouble];
    return self;
}

- (BOOL)isVertical
{
    return [(SliderCell *)cell isVertical];
}

@end
