/* Interface for OpenPanel class
 *
 * Copyright (C)  1993  The Board of Trustees of  
 * The Leland Stanford Junior University.  All Rights Reserved.
 *
 * Authors: Scott Francis, Paul Kunz, Imran Qureshi, and Libing Wang
 *
 * This file is part of an Objective-C class library for a window system
 *
 * OpenPanel.m,v 1.23 1994/06/14 02:21:53 pfkeb Exp
 */

 
#include "OpenPanel.h"

static OpenPanel *panelInstance = nil;

@implementation OpenPanel:SavePanel


// + setOpenPanelFactory:factoryId;

+ new
{
    if (!panelInstance) {
	panelInstance = [[OpenPanel alloc] init];
    }
    return panelInstance;
}

// + newContent:(const NXRect *)contentRect style:(int)aStyle 
//	backing:(int)bufferingType buttonMask:(int)mask defer:(BOOL)flag

- allowMultipleFiles:(BOOL)flag
{
    _allowMultipleFiles = flag;
    return self;
}

// - (const char *const *)filenames;

- (int)runModalForDirectory:(const char *)path file:(const char *)name 
                                  types:(const char *const *)fileTypes
{
  /* need to set resources first, then */
    return [self runModal];
}

- (int)runModalForTypes:(const char *const *)fileTypes
{
 /* Need to add handling of file selector's filters */
   return [self runModal];  
}

- (int)runModalForDirectory:(const char *)path file:(const char *)name
{
  /* Needs to set the widget resources, then */
    return [self runModal];
}

/* Methods not in NextStep */

- init
{
    [super init];
    instancename = "OpenPanel";
    return self;
}
@end
