/*
    NXImageRep.m - Abstract image representation.

    Copyright (c) 1993, Adam Fedor. 
*/

#include "NXImageRep.h"
#include <objc2/typedstream2.h>

extern const char *NXImageRepInstanceName(void);
@interface NXImageRep(ToolKit)
- (BOOL)_displayDrawAt:(const NXPoint *)point;
@end

@implementation NXImageRep

- init
{
    const char *instance_name;
    [super init];
    instance_name = NXImageRepInstanceName();
    return self;
}

- (BOOL)drawAt:(const NXPoint *)point
{
    if (![self _displayDrawAt:point])
	return NO;
    return [self draw];
}

- (BOOL)drawIn:(const NXRect *)rect
{
    return [self draw];
}

- (BOOL)draw
{
    return NO;
}

- setSize:(const NXSize *)aSize
{
    size = *aSize;
    return self;
}

- getSize:(NXSize *)aSize
{
    *aSize = size;
    return self;
}

- setNumColors:(int)anInt
{
    _repFlags.numColors = anInt;
    return self;
}

- (int)numColors
{
    return _repFlags.numColors;
}

- setBitsPerSample:(int)anInt
{
    _repFlags.bitsPerSample = anInt;
    return self;
}

- (int)bitsPerSample
{
    return _repFlags.bitsPerSample;
}

- setPixelsWide:(int)anInt
{
    _pixelsWide = anInt;
    return self;
}

- (int)pixelsWide
{
    return _pixelsWide;
}

- setPixelsHigh:(int)anInt
{
    _pixelsHigh = anInt;
    return self;
}

- (int)pixelsHigh
{
    return _pixelsHigh;
}

- read:(TypedStream *)stream
{
    unsigned int    a, b, c, d;

    [super read:stream];
    NXReadTypes(stream, "IIIIii", 
	    &a, &b, &c, &d, &_pixelsWide, &_pixelsHigh);
    NXReadType(stream, "{ff}", &size);
    _repFlags.numColors     = a;
    _repFlags.bitsPerSample = b;
    _repFlags.dataSource    = c;
    _repFlags.dataLoaded    = d;
    return self;
}

- write:(TypedStream *)stream
{
    unsigned int    a, b, c, d;

    [super read:stream];
    a = _repFlags.numColors;
    b = _repFlags.bitsPerSample;
    c = _repFlags.dataSource;
    d = _repFlags.dataLoaded;
    NXWriteTypes(stream, "IIIIii", 
	    &a, &b, &c, &d, &_pixelsWide, &_pixelsHigh);
    NXWriteType(stream, "{ff}", &size);
    return self;
}

+ (const char *const *)imageUnfilteredFileTypes
{
    static const char *const iutypes[] = {NULL};
    return iutypes;
}

+ (const char *const *)imageFileTypes
{
    static const char *const itypes[] = {NULL};
    return itypes;
}

+ (const NXAtom *)imageUnfilteredPasteboardTypes
{
    static NXAtom iuptypes[1] = {NULL};
    return (const NXAtom *)iuptypes;
}

+ (const NXAtom *)imagePasteboardTypes
{
    static NXAtom iptypes[1] = {NULL};
    return (const NXAtom *)iptypes;
}

+ (BOOL)canLoadFromStream:(NXStream *)stream
{
    return NO;
}

@end

