/*
    NXImageRep.h - Abstract image representation.

    Mirrors the interface file for the NeXT class. 
*/

#ifndef _NXImageRep_h_
#define _NXImageRep_h_

#include <objc/Object.h>
#include <streams/streams.h>
#include <objc/typedstream.h>
#include <objc2/hashtable.h>  /* NXAtom */
#include <dpsclient/event.h>  /* NXSize, etc. */
#include "graphics.h"	      /* NXRect */


/*
 * NX_MATCHESDEVICE indicates the value is variable, depending on the output
 * device. It can be the passed in (or received back) as the value of 
 * numColors, bitsPerSample, or pixelsWide & pixelsHigh.
 */
#define NX_MATCHESDEVICE    (0)

@interface NXImageRep : Object
{
    struct __repFlags {
    unsigned int numColors:3;
    unsigned int bitsPerSample:6;
    unsigned int dataSource:3;
    unsigned int dataLoaded:1;
    unsigned int _RESERVED:3;
    }                   _repFlags;
    NXSize              size;
    int                 _pixelsWide;
    int                 _pixelsHigh;
}

- (BOOL)drawAt:(const NXPoint *)point;
- (BOOL)drawIn:(const NXRect *)rect;
- (BOOL)draw;
- setSize:(const NXSize *)aSize;
- getSize:(NXSize *)aSize;
- setNumColors:(int)anInt;
- (int)numColors;
- setBitsPerSample:(int)anInt;
- (int)bitsPerSample;
- setPixelsWide:(int)anInt;
- (int)pixelsWide;
- setPixelsHigh:(int)anInt;
- (int)pixelsHigh;

- read:(TypedStream *)stream;
- write:(TypedStream *)stream;

+ (const char *const *)imageUnfilteredFileTypes;
+ (const char *const *)imageFileTypes;
+ (const NXAtom *)imageUnfilteredPasteboardTypes;
+ (const NXAtom *)imagePasteboardTypes;
+ (BOOL)canLoadFromStream:(NXStream *)stream;

@end

#endif
