/*
    NXImage.h - class to load an manipulate images

    Copyright (C) 1993, Adam Fedor. Header file from NeXT

    NXImage.h,v 1.5 1994/06/11 03:56:27 pfkeb Exp
*/

#ifndef _NXImage_h_
#define _NXImage_h_

#include <objc/Object.h>
#include <objc2/hashtable.h>  /* NXAtom */
#include "graphics.h"
#include "color.h"

@class NXImageRep;
@class List;
@class Storage;

@interface NXImage : Object
{
    char               *name;
    NXSize              _size;
    struct __imageFlags {
#ifdef __BIG_ENDIAN__
	unsigned int        scalable:1;
	unsigned int        dataRetained:1;
	unsigned int        flipDraw:1;
	unsigned int        uniqueWindow:1;
	unsigned int        uniqueWasExplicitlySet:1;
	unsigned int        sizeWasExplicitlySet:1;
	unsigned int        builtIn:1;
	unsigned int        needsToExpand:1;
	unsigned int        useEPSOnResolutionMismatch:1;
	unsigned int        colorMatchPreferred:1;
	unsigned int        multipleResolutionMatching:1;
	unsigned int        dontFreeName:1;
	unsigned int        subImage:1;
	unsigned int	    aSynch:1;
	unsigned int	    archiveByName:1;
	unsigned int	    unboundedCacheDepth:1;
#else
	unsigned int        unboundedCacheDepth:1;
	unsigned int        archiveByName:1;
	unsigned int        aSynch:1;
	unsigned int        subImage:1;
	unsigned int        dontFreeName:1;
	unsigned int        multipleResolutionMatching:1;
	unsigned int        colorMatchPreferred:1;
	unsigned int        useEPSOnResolutionMismatch:1;
	unsigned int        needsToExpand:1;
	unsigned int        builtIn:1;
	unsigned int        sizeWasExplicitlySet:1;
	unsigned int        uniqueWasExplicitlySet:1;
	unsigned int        uniqueWindow:1;
	unsigned int        flipDraw:1;
	unsigned int        dataRetained:1;
	unsigned int        scalable:1;
#endif
    }                   _flags;
    Storage            *_reps;
    List               *_repList;
    NXColor             _color;
    id			delegate;
}

+ findImageNamed:(const char *)aName;

- init;
- initSize:(const NXSize *)aSize;
- initFromFile:(const char *)fileName;
- initFromStream:(NXStream *)stream;
- initFromImage:(NXImage *)image rect:(const NXRect *)rect;

- getImage:(NXImage **)image rect:(NXRect *)rect;
- setSize:(const NXSize *)aSize;
- getSize:(NXSize *)aSize;
- free;
- (BOOL)setName:(const char *)string;
- (const char *)name;
- setFlipped:(BOOL)flag;
- (BOOL)isFlipped;
- setScalable:(BOOL)flag;
- (BOOL)isScalable;
- setDataRetained:(BOOL)flag;
- (BOOL)isDataRetained;
- setUnique:(BOOL)flag;
- (BOOL)isUnique;
- setCacheDepthBounded:(BOOL)flag;
- (BOOL)isCacheDepthBounded;
- setBackgroundColor:(NXColor)aColor;
- (NXColor)backgroundColor;
- setEPSUsedOnResolutionMismatch:(BOOL)flag;
- (BOOL)isEPSUsedOnResolutionMismatch;
- setColorMatchPreferred:(BOOL)flag;
- (BOOL)isColorMatchPreferred;
- setMatchedOnMultipleResolution:(BOOL)flag;
- (BOOL)isMatchedOnMultipleResolution;
- dissolve:(float)delta toPoint:(const NXPoint *)point;
- dissolve:(float)delta	fromRect:(const NXRect *)rect toPoint:(const NXPoint *)point;
- composite:(int)op toPoint:(const NXPoint *)point;
- composite:(int)op fromRect:(const NXRect *)rect toPoint:(const NXPoint *)point;
- (BOOL)drawRepresentation:(NXImageRep *)imageRep inRect:(const NXRect *)rect;
- recache;
- writeTIFF:(NXStream *)stream;
- writeTIFF:(NXStream *)stream allRepresentations:(BOOL)flag;
- writeTIFF:(NXStream *)stream allRepresentations:(BOOL)flag usingCompression:(int)compression andFactor:(float)aFloat;
- write:(NXTypedStream *)stream;
- read:(NXTypedStream *)stream;
- finishUnarchiving;
- (BOOL)loadFromStream:(NXStream *)stream;
- (BOOL)loadFromFile:(const char *)fileName;
- (BOOL)useFromFile:(const char *)fileName;
- (BOOL)useDrawMethod:(SEL)drawMethod inObject:anObject;
- (BOOL)useRepresentation:(NXImageRep *)imageRepresentation;
- (BOOL)useCacheWithDepth:(int)depth;
- removeRepresentation:(NXImageRep *)imageRepresentation;
- (BOOL)lockFocus;
- (BOOL)lockFocusOn:(NXImageRep *)imageRepresentation;
- unlockFocus;
- (NXImageRep *)lastRepresentation;
- (NXImageRep *)bestRepresentation;
- (List *)representationList;
- setDelegate:(id)anObject;
- delegate;


+ (void)registerImageRep:imageRepClass;
+ (void)unregisterImageRep:imageRepClass;
+ (Class *)imageRepForFileType:(const char *)type;
+ (Class *)imageRepForPasteboardType:(NXAtom)type;
+ (Class *)imageRepForStream:(NXStream *)stream;
+ (const char *const *)imageUnfilteredFileTypes;
+ (const char *const *)imageFileTypes;
+ (const NXAtom *)imageUnfilteredPasteboardTypes;
+ (const NXAtom *)imagePasteboardTypes;

@end

@interface Object(NXImageDelegate)
- (NXImage *)imageDidNotDraw:sender inRect:(const NXRect *)aRect;
@end

#endif
