/*
    NXCachedImageRep - wrapped for cashing images

    Copyright (c) 1994, Adam Fedor.

    Keeps a representation of an image in an off-screen window.  If the
    message initFromWindow:rect: is sent with a nil window, one is created
    using the rect information.
*/

#include "NXCachedImageRep.h"
#include "Window.h"

extern const char *NXCachedImageRepInstanceName(void);

@interface NXCachedImageRep(ToolKit)
- (BOOL)_displayDraw;
@end

@implementation NXCachedImageRep

- initFromWindow:(Window *)win rect:(const NXRect *)rect
{
    const char *instance_name;
    [super init];
    instance_name = NXCachedImageRepInstanceName();
    _window = win;
    _rect   = *rect;
    /* Either win or rect must be non-NULL otherwise we return nil. If rect
       is NULL, we get the frame info from the window. If win is nil we
       create it from the rect information.
    */
    if (!rect || NX_WIDTH(rect) == 0 || NX_HEIGHT(rect) == 0) {
	if (!win) {
	    [self free];
	    return nil;
	}
	[win getFrame:&_rect];
    }
    if (!_window)
	_window = [[Window alloc] initContent:&_rect];
/*
    	_window = [[[Window allocFromZone:[self zone]] initContent:&_rect
			  style:NX_PLAINSTYLE
			backing:NX_RETAINED
		     buttonMask:0
			  defer:NO] reenableDisplay];
*/

    return self;
}

- getWindow:(Window **)win andRect:(NXRect *)rect
{
    *win = _window;
    if (rect)
    	*rect = _rect;
    return self;
}

- (BOOL)draw
{
    return [self _displayDraw];
}

- read:(NXTypedStream *)stream
{
    [super read:stream];
    return self;
}

- write:(NXTypedStream *)stream
{
    [super write:stream];
    return self;
}

- copyFromZone:(NXZone *)zone
{
    return [super copy];
}

- free
{
    return [super free];
}

@end

