/*
    NXBitmapImageRep - Image representation for bitmap images.

*/

#ifndef _NXBitmapImageRep_h_
#define _NXBitmapImageRep_h_

#include <coll/List.h>
#include "graphics.h"
#include "NXImageRep.h"

@interface NXBitmapImageRep : NXImageRep
{
    unsigned int    _bytesPerRow;
    unsigned short  _imageNumber;
    short           _colorSpace;
    struct __bitmapRepFlags {
#ifdef __BIG_ENDIAN__
	unsigned int isPlanar:1;
	unsigned int explicitPlanes:1;
	unsigned int unpackedOK:1;
	unsigned int isUnpacked:1;
	unsigned int memory:2;
	unsigned int _RESERVED:2;
#else
	unsigned int _RESERVED:2;
	unsigned int memory:2;
	unsigned int isUnpacked:1;
	unsigned int unpackedOK:1;
	unsigned int explicitPlanes:1;
	unsigned int isPlanar:1;
#endif
    }               _moreRepFlags;
    unsigned int    bitsPerPixel;   
    char            *_fileName;
    unsigned short  compression;
    unsigned char   **_data;
}

- initFromFile:(const char *)fileName;
- initFromStream:(NXStream *)stream;
- initData: (void *)data pixelsWide:(int)width
		pixelsHigh:(int)height
		bitsPerSample:(int)bps
		samplesPerPixel:(int)spp
		hasAlpha:(BOOL)alpha
		isPlanar:(BOOL)isPlanar
		colorSpace:(int)colorSpace
		bytesPerRow:(int)rBytes
		bitsPerPixel:(int)pBits;
- initDataPlanes:(unsigned char **)planes pixelsWide:(int)width 
		pixelsHigh:(int)height 
		bitsPerSample:(int)bps 
		samplesPerPixel:(int)spp 
		hasAlpha:(BOOL)alpha 
		isPlanar:(BOOL)isPlanar 
		colorSpace:(int)colorSpace 
		bytesPerRow:(int)rBytes 
		bitsPerPixel:(int)pBits;

+ (List *)newListFromFile:(const char *)fileName;
+ (List *)newListFromStream:(NXStream *)stream;

+ (const char *const *)imageUnfilteredFileTypes;
+ (const NXAtom *)imageUnfilteredPasteboardTypes;
+ (BOOL) canLoadFromStream:(NXStream *)stream;

- (unsigned char *)data;
- getDataPlanes:(unsigned char **)data;
- (BOOL)isPlanar;
- (int)samplesPerPixel;
- (int)bitsPerPixel;
- (int)bytesPerRow;
- (int)bytesPerPlane;
- (int)numPlanes;
- (int)colorSpace;
- (BOOL)drawIn:(const NXRect *)rect;
- (BOOL)draw;
- free;

@end

#endif
