/* Implementation for MenuCell
 *
 * Copyright (C)  1993  The Board of Trustees of The Leland Stanford
 *                      Junior University.  All Rights Reserved.
 * 
 * Authors: Paul Kunz, Tom Pavel, and Libing Wang (SLAC)
 *	    Mike Kienenberger (Alaska)
 *
 * This file is part of an Objective-C class library for a window system
 *
 * MenuCell.m,v 1.26 1994/06/11 03:56:16 pfkeb Exp
 */


#include "MenuCell.h"

/* Required for implementation: */
#include "Menu.h"

#include <stdlib.h>             /* for free() */
#include <stdio.h>

extern char *MenuCellInstanceName(void);


@implementation MenuCell:ButtonCell


- init
{
   [super init];
   instancename = MenuCellInstanceName();
   [self _init];
   return self;
}

- copy
{
    MenuCell	*newCell;

    newCell = [super copy];
    if ( subMenu ) {
        [newCell setSubmenu:[subMenu copy]];
    }
    return newCell;
}

- free
{
   if (subMenu) 
	free(subMenu);
   return [super free];
}

- (BOOL)hasSubmenu
{
    return (subMenu != NULL);
}

- setSubmenu:aMenu
 /*	Deposits a submenu in the menu tree  */
{
    subMenu = aMenu;
    [self _setSubmenu];
    return self;
}

- setState:(int) value
{
  /* override method to avoid highlighting */
    state = value ? 1 : 0;
    return self;
}

- setUpdateAction:(SEL)aSelector forMenu:aMenu
 /* 
	For use in the future when we want to be able to dictate
	which menu items are selected and which are not.
 	Allows one to set up the action which the item calls to update
	itself.
 */
{
    [aMenu setAutoupdate:YES];
    updateAction = aSelector;
    return self;
}

- (SEL)updateAction
{
    return updateAction;
}

- read:(TypedStream *)typedStream
{
    [super read:typedStream];

/*
    objc_read_object(typedStream, &subMenu);
    objc_read_type(typedStream, "int", &numargs);
    objc_read_type(typedStream, "int", &allocedargs);
    objc_read_type(typedStream, "int", &arglist);
    objc_read_type(typedStream, "int", &widgetid);
*/

    return self;
}
    
- awake
{
    [super awake];
    
    [self _init];
#ifdef DEBUG
    fprintf(stderr, "MenuCell '%s': awake\n", contents);
    fprintf(stderr, "target = %d, action = %d\n", target, action);
#endif

    return self;
}

- write:(TypedStream *)typedStream
{
    [super write:typedStream];

    objc_write_object(typedStream, subMenu);
    objc_write_type(typedStream, "i", &numargs);
    objc_write_type(typedStream, "i", &allocedargs);
    objc_write_type(typedStream, "int", arglist);
    objc_write_type(typedStream, "int", widgetid);

    return self;
}

@end
