#define FLEX_COMPRESSED
/* A lexical scanner generated by flex */

/* scanner skeleton version:
 * $Header: flex.skel,v 2.0 89/06/20 15:49:46 vern Locked $
 */

#include <stdio.h>

#define FLEX_SCANNER

/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of input buffer */
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */

#define ECHO fputs( zztext, zzout )

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#define YY_INPUT(buf,result,max_size) \
	if ( (result = read( fileno(zzin), buf, max_size )) < 0 ) \
	    YY_FATAL_ERROR( "read() in flex scanner failed" );
#define YY_NULL 0
#define zzterminate() return ( YY_NULL )

/* report a fatal error */
#define YY_FATAL_ERROR(msg) \
	{ \
	fputs( msg, stderr ); \
	putc( '\n', stderr ); \
	exit( 1 ); \
	}

/* default zzwrap function - always treat EOF as an EOF */
#define zzwrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN zz_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE goto new_file

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#ifdef __STDC__
#define YY_DECL int zzlex( void )
#else
#define YY_DECL int zzlex()
#endif

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

/* done after the current pattern has been matched and before the
 * corresponding action - sets up zztext
 */
#define YY_DO_BEFORE_ACTION \
	zztext = zz_bp; \
	zz_hold_char = *zz_cp; \
	*zz_cp = '\0'; \
	zz_c_buf_p = zz_cp;

/* returns the length of the matched text */
#define zzleng (zz_cp - zz_bp)

#define EOB_ACT_RESTART_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define zzless(n) \
	{ \
	*zz_cp = zz_hold_char; /* undo effects of setting up zztext */ \
	zz_c_buf_p = zz_cp = zz_bp + n; \
	YY_DO_BEFORE_ACTION; /* set up zztext again */ \
	}

#define unput(c) zzunput( c, zz_bp )

#define YY_USER_ACTION

FILE *zzin = (FILE *) 0, *zzout = (FILE *) 0;
char *zztext;

#ifndef __STDC__
#define const
#endif

# line 1 "vload.l"
#define INITIAL 0
/*
** A Vehicle loader that uses LEX to parse things
** Written by Gordon Smith (aahz@eng.umd.edu)
** Hacked on a bit by lidl@pix.com
*/
/* $Id: vload.l,v 1.6 1992/02/06 09:01:46 aahz Exp $ */
# line 10 "vload.l"
#ifdef YY_DECL
#undef YY_DECL
#endif
#define YY_DECL zzlex(d) Vdesc *d;

#include <stdio.h>
#include <string.h>

#include "xtank.h"
#include "vdesc.h"
#include "vehicle.h"
#include "vstructs.h"
#include "setup.h"
#include "globals.h"
#include "team.h"
/* For "UNDEFINED" */
#include "interface.h"
#include "terminal.h"

#define BUFLEN 256
#define SEP ",\t"

extern char *games_entries[];
extern Settings settings;
extern int num_terminals;
extern Terminal *terminal[];
extern char *Wnames[VMAX_WEAPONS];
extern char *Mnames[NUM_MOUNTS];
extern char *Snames[MAX_SIDES];

static int iGblRetCode;

char *zval(), *strtoke();
void cv_str(), cv_kw2i(), cv_bool(), cv_int(), cv_flt();
void cv_armr(), cv_body(), cv_bump(), cv_engine();
void cv_special(), cv_susp(), cv_tread(), cv_weap();

# line 55 "vload.l"
#define YY_END_OF_BUFFER 21
typedef int zz_state_type;
static const short int zz_accept[205] =
    {   0,
        0,    0,   21,   20,    1,   20,   20,   20,   20,   20,
       20,   20,   20,   20,   20,   20,   20,   20,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,

        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,   13,    0,    0,    7,    0,
        0,   10,    5,    0,    0,    0,    0,    0,    0,    0,
       11,    0,    0,    0,    0,    0,    0,    0,    0,    0,
        0,    0,    0,    0,    0,    9,    0,   12,    0,    0,
        0,    0,    0,    0,    0,   14,    0,    0,    0,    6,
        0,    0,    0,    0,   18,    0,    0,    0,    0,   19,
        0,    0,    0,   15,    0,    3,    0,    0,    4,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,    8,

       16,   17,    2,    0
    } ;

static const char zz_ec[128] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    4,    1,    1,    5,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    6,    7,    6,
        8,    9,    6,   10,    1,    1,    1,   11,    1,    1,
        1,    1,    1,    1,   12,   13,    1,   14,   15,   16,
        1,   17,    1,    1,    1,   18,    1,    1,    1,    1,
        1,   19,   20,   21,    1,   22,   23,    1,    1,    1,
        1,    1,    1,    1,    1,    1,   24,    1,   25,   26,

       27,   28,   29,   30,   31,    1,   32,   33,   34,   35,
       36,   37,    1,   38,   39,   40,   41,    1,    1,   42,
       43,    1,    1,    1,    1,    1,    1
    } ;

static const char zz_meta[44] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1
    } ;

static const short int zz_base[223] =
    {   0,
      291,    0,  293,  295,  295,  254,    0,  264,  255,  251,
      261,  260,  255,    2,    2,  258,  279,  243,  248,  256,
        4,  246,  240,  249,  241,  252,  247,  245,  246,  233,
      234,  243,  239,    0,  244,  231,  234,  222,  224,  226,
      231,  230,  225,  219,  218,  227,  231,  218,  243,  229,
      221,  240,  215,  211,  237,  236,  210,  218,  215,  208,
      202,  237,  229,  199,  207,  210,    0,  210,  210,   23,
      202,  229,   24,   27,  198,  193,  195,  202,  217,  188,
       30,  215,  201,  189,   31,  184,  189,   43,  210,  199,
       44,   47,  208,  179,  190,  205,   48,  184,   51,   52,

      181,  174,  209,   55,  200,  183,  206,   58,   61,  165,
      204,   64,  203,   67,   70,  194,  166,   71,   74,  168,
      199,   77,   80,  190,  169,  295,   81,  188,  295,   84,
      161,  295,  295,   85,   88,  186,   91,  193,   94,  163,
      295,  191,   97,  100,  157,  101,  104,  185,  164,  187,
      107,  110,  111,  186,  114,  295,  149,  295,  117,  152,
      183,  120,  123,  176,  173,  295,  180,  126,  129,  295,
      171,  178,  132,  169,  295,  176,  135,  170,  138,  295,
      174,  141,  144,  295,  145,  295,  168,  148,  295,  149,
      152,  165,  171,  155,  170,  158,  169,  161,  168,  295,

      295,  295,  295,  295,  165,  169,  168,  167,  154,  140,
      131,  125,  119,  106,   93,   76,   63,   36,   10,    9,
        4,    0
    } ;

static const short int zz_def[223] =
    {   0,
      205,  205,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  206,  204,  204,  207,  204,  204,
      208,  209,  204,  204,  204,  204,  204,  204,  210,  204,

      204,  204,  206,  206,  204,  204,  207,  207,  204,  204,
      208,  208,  209,  209,  204,  204,  204,  204,  211,  204,
      210,  210,  212,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  213,  204,  204,  214,  211,  211,  204,
      204,  212,  212,  204,  204,  215,  204,  204,  204,  213,
      213,  216,  204,  214,  214,  204,  204,  204,  217,  204,
      215,  215,  218,  204,  204,  204,  216,  216,  219,  204,
      204,  217,  217,  204,  204,  218,  218,  204,  204,  204,
      219,  219,  204,  204,  204,  204,  204,  220,  204,  221,
      222,  204,  220,  220,  221,  221,  222,  222,  204,  204,

      204,  204,  204,    0,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204
    } ;

static const short int zz_nxt[339] =
    {   0,
      197,   85,    5,   85,  195,   52,   52,   52,   52,  193,
      181,    6,    7,    8,    9,   10,   11,   12,   13,   14,
       15,   16,   17,   20,   88,   91,   88,   91,   92,   38,
       92,   99,  104,   99,  104,   21,  176,   31,   29,   32,
       22,   18,   30,   39,  108,  112,  108,  112,  114,  119,
      114,  119,  122,  123,  122,  123,  104,  126,  104,  108,
      129,  108,  130,  172,  130,  112,  132,  112,  114,  133,
      114,  134,  137,  134,  137,  139,  167,  139,  122,  141,
      122,  143,  146,  143,  146,  130,  151,  130,  151,  152,
      148,  152,  155,  161,  155,  139,  156,  139,  143,  158,

      143,  159,  162,  159,  162,  163,  154,  163,  151,  166,
      151,  168,  169,  168,  169,  155,  170,  155,  173,  150,
      173,  162,  175,  162,  177,  142,  177,  168,  180,  168,
      182,  138,  182,  173,  184,  173,  177,  186,  177,  188,
      121,  188,  182,  189,  182,  190,  191,  190,  191,  194,
      196,  194,  196,  198,  113,  198,  194,  200,  194,  196,
      201,  196,  198,  202,  198,    4,    4,  111,  107,  103,
      203,  202,  201,  200,  199,  192,  189,  187,  186,  185,
      184,  183,  180,  179,  178,  175,  174,  171,  170,  166,
      165,  164,  160,  158,  157,  156,  153,  149,  147,  145,

      144,  141,  140,  136,  135,  133,  132,  131,  129,  128,
      127,  126,  125,  124,  120,  118,  117,  116,  115,  110,
      109,  106,  105,  102,  101,  100,   98,   97,   96,   95,
       94,   93,   90,   89,   87,   86,   84,   83,   82,   81,
       80,   79,   78,   77,   76,   75,   74,   73,   72,   71,
       70,   69,   68,   67,   66,   65,   64,   63,   62,   61,
       60,   59,   58,   57,   56,   55,   54,   53,   51,   50,
       49,   48,   47,   46,   45,   44,   43,   42,   41,   40,
       37,   36,   35,   34,   33,   28,   27,   26,   25,   24,
       23,   19,  204,    5,    3,  204,  204,  204,  204,  204,

      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204
    } ;

static const short int zz_chk[339] =
    {   0,
      222,   67,    2,   67,  221,   34,   34,   34,   34,  220,
      219,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    7,   70,   73,   70,   73,   74,   21,
       74,   81,   85,   81,   85,    7,  218,   15,   14,   15,
        7,    2,   14,   21,   88,   91,   88,   91,   92,   97,
       92,   97,   99,  100,   99,  100,  104,  104,  104,  108,
      108,  108,  109,  217,  109,  112,  112,  112,  114,  114,
      114,  115,  118,  115,  118,  119,  216,  119,  122,  122,
      122,  123,  127,  123,  127,  130,  134,  130,  134,  135,
      130,  135,  137,  215,  137,  139,  139,  139,  143,  143,

      143,  144,  146,  144,  146,  147,  214,  147,  151,  151,
      151,  152,  153,  152,  153,  155,  155,  155,  159,  213,
      159,  162,  162,  162,  163,  212,  163,  168,  168,  168,
      169,  211,  169,  173,  173,  173,  177,  177,  177,  179,
      210,  179,  182,  182,  182,  183,  185,  183,  185,  188,
      190,  188,  190,  191,  209,  191,  194,  194,  194,  196,
      196,  196,  198,  198,  198,  205,  205,  208,  207,  206,
      199,  197,  195,  193,  192,  187,  181,  178,  176,  174,
      172,  171,  167,  165,  164,  161,  160,  157,  154,  150,
      149,  148,  145,  142,  140,  138,  136,  131,  128,  125,

      124,  121,  120,  117,  116,  113,  111,  110,  107,  106,
      105,  103,  102,  101,   98,   96,   95,   94,   93,   90,
       89,   87,   86,   84,   83,   82,   80,   79,   78,   77,
       76,   75,   72,   71,   69,   68,   66,   65,   64,   63,
       62,   61,   60,   59,   58,   57,   56,   55,   54,   53,
       52,   51,   50,   49,   48,   47,   46,   45,   44,   43,
       42,   41,   40,   39,   38,   37,   36,   35,   33,   32,
       31,   30,   29,   28,   27,   26,   25,   24,   23,   22,
       20,   19,   18,   17,   16,   13,   12,   11,   10,    9,
        8,    6,    3,    1,  204,  204,  204,  204,  204,  204,

      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204,  204,  204,
      204,  204,  204,  204,  204,  204,  204,  204
    } ;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define zzmore() zzmore_used_but_not_detected

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
static char *zz_c_buf_p;	/* points to current character in buffer */
static int zz_init = 1;		/* whether we need to initialize */
static int zz_start = 0;	/* start state number */

/* true when we've seen an EOF for the current input file */
static int zz_eof_has_been_seen;

static int zz_n_chars;		/* number of characters read into zz_ch_buf */

/* zz_ch_buf has to be 2 characters longer than YY_BUF_SIZE because we need
 * to put in 2 end-of-buffer characters (this is explained where it is
 * done) at the end of zz_ch_buf
 */
static char zz_ch_buf[YY_BUF_SIZE + 2];

/* zz_hold_char holds the character lost when zztext is formed */
static char zz_hold_char;

static zz_state_type zz_last_accepting_state;
static char *zz_last_accepting_cpos;

#ifdef __STDC__
static zz_state_type zz_get_previous_state( void );
static int zz_get_next_buffer( void );
static void zzunput( int c, char *buf_ptr );
static int input( void );
static void zzrestart( FILE *input_file );
#else
static zz_state_type zz_get_previous_state();
static int zz_get_next_buffer();
static void zzunput();
static int input();
static void zzrestart();
#endif

YY_DECL
    {
    register zz_state_type zz_current_state;
    register char *zz_cp, *zz_bp;
    register int zz_act;




    if ( zz_init )
	{
	if ( ! zz_start )
	    zz_start = 1;	/* first start state */

	if ( ! zzin )
	    zzin = stdin;

	if ( ! zzout )
	    zzout = stdout;

new_file:
	/* this is where we enter upon encountering an end-of-file and
	 * zzwrap() indicating that we should continue processing
	 */

	/* we put in the '\n' and start reading from [1] so that an
	 * initial match-at-newline will be true.
	 */

	zz_ch_buf[0] = '\n';
	zz_n_chars = 1;

	/* we always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	zz_ch_buf[zz_n_chars] = YY_END_OF_BUFFER_CHAR;
	zz_ch_buf[zz_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	zz_eof_has_been_seen = 0;

	zztext = zz_c_buf_p = &zz_ch_buf[1];
	zz_hold_char = *zz_c_buf_p;
	zz_init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	zz_cp = zz_c_buf_p;

	/* support of zztext */
	*zz_cp = zz_hold_char;

	/* zz_bp points to the position in zz_ch_buf of the start of the
	 * current run.
	 */
	zz_bp = zz_cp;

	zz_current_state = zz_start;
	if ( zz_bp[-1] == '\n' )
	    ++zz_current_state;
	do
	    {
	    register char zz_c = zz_ec[*zz_cp];
	    if ( zz_accept[zz_current_state] )
		{
		zz_last_accepting_state = zz_current_state;
		zz_last_accepting_cpos = zz_cp;
		}
	    while ( zz_chk[zz_base[zz_current_state] + zz_c] != zz_current_state )
		{
		zz_current_state = zz_def[zz_current_state];
		if ( zz_current_state >= 205 )
		    zz_c = zz_meta[zz_c];
		}
	    zz_current_state = zz_nxt[zz_base[zz_current_state] + zz_c];
	    ++zz_cp;
	    }
	while ( zz_current_state != 204 );
	zz_cp = zz_last_accepting_cpos;
	zz_current_state = zz_last_accepting_state;

	/* bogus while loop to let YY_BACK_TRACK, EOB_ACT_LAST_MATCH,
	 * and EOF actions branch here without introducing an optimizer-
	 * daunting goto
	 */
	while ( 1 )
	    {
	    zz_act = zz_accept[zz_current_state];

	    YY_DO_BEFORE_ACTION;
	    YY_USER_ACTION;

#ifdef FLEX_DEBUG
	    fprintf( stderr, "--accepting rule #%d (\"%s\")\n",
		     zz_act, zztext );
#endif

do_action:	/* this label is used only to access EOF actions */
	    switch ( zz_act )
		{
		case 0: /* must backtrack */
		/* undo the effects of YY_DO_BEFORE_ACTION */
		*zz_cp = zz_hold_char;
		zz_cp = zz_last_accepting_cpos;
		zz_current_state = zz_last_accepting_state;
		continue; /* go to "YY_DO_BEFORE_ACTION" */

case 1:
# line 57 "vload.l"
{ }
	YY_BREAK
case 2:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 58 "vload.l"
{ }
	YY_BREAK
case 3:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 59 "vload.l"
{ strcpy(d->name, zval()); }
	YY_BREAK
case 4:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 60 "vload.l"
{ strcpy(d->designer, zval()); }
	YY_BREAK
case 5:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 61 "vload.l"
{ cv_body(zval(), d); }
	YY_BREAK
case 6:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 62 "vload.l"
{ cv_engine(zval(), d); }
	YY_BREAK
case 7:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 63 "vload.l"
{ cv_weap(zztext[2], zval(), d); }
	YY_BREAK
case 8:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 64 "vload.l"
{ cv_armr(zval(), d); }
	YY_BREAK
case 9:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 65 "vload.l"
{ cv_int(zval(), &d->armor.side[FRONT]); }
	YY_BREAK
case 10:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 66 "vload.l"
{ cv_int(zval(), &d->armor.side[BACK]); }
	YY_BREAK
case 11:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 67 "vload.l"
{ cv_int(zval(), &d->armor.side[LEFT]); }
	YY_BREAK
case 12:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 68 "vload.l"
{ cv_int(zval(), &d->armor.side[RIGHT]); }
	YY_BREAK
case 13:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 69 "vload.l"
{ cv_int(zval(), &d->armor.side[TOP]); }
	YY_BREAK
case 14:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 70 "vload.l"
{ cv_int(zval(), &d->armor.side[BOTTOM]); }
	YY_BREAK
case 15:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 71 "vload.l"
{ cv_special(zval(), d);}
	YY_BREAK
case 16:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 72 "vload.l"
{ cv_int(zval(), &d->heat_sinks);}
	YY_BREAK
case 17:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 73 "vload.l"
{ cv_susp(zval(), d); }
	YY_BREAK
case 18:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 74 "vload.l"
{ cv_tread(zval(), d); }
	YY_BREAK
case 19:
*zz_cp = zz_hold_char; /* undo effects of setting up zztext */
zz_c_buf_p = zz_cp -= 1;
YY_DO_BEFORE_ACTION; /* set up zztext again */
# line 75 "vload.l"
{ cv_bump(zval(), d);}
	YY_BREAK
case 20:
# line 77 "vload.l"
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
    zzterminate();

		case YY_END_OF_BUFFER:
		    /* undo the effects of YY_DO_BEFORE_ACTION */
		    *zz_cp = zz_hold_char;

		    zztext = zz_bp;

		    switch ( zz_get_next_buffer() )
			{
			case EOB_ACT_END_OF_FILE:
			    {
			    if ( zzwrap() )
				{
				/* note: because we've taken care in
				 * zz_get_next_buffer() to have set up zztext,
				 * we can now set up zz_c_buf_p so that if some
				 * total hoser (like flex itself) wants
				 * to call the scanner after we return the
				 * YY_NULL, it'll still work - another YY_NULL
				 * will get returned.
				 */
				zz_c_buf_p = zztext;

				zz_act = YY_STATE_EOF((zz_start - 1) / 2);
				goto do_action;
				}

			    else
				YY_NEW_FILE;
			    }
			    break;

			case EOB_ACT_RESTART_SCAN:
			    zz_c_buf_p = zztext;
			    zz_hold_char = *zz_c_buf_p;
			    break;

			case EOB_ACT_LAST_MATCH:
			    zz_c_buf_p = &zz_ch_buf[zz_n_chars];

			    zz_current_state = zz_get_previous_state();

			    zz_cp = zz_c_buf_p;
			    zz_bp = zztext;
			    continue; /* go to "YY_DO_BEFORE_ACTION" */
			}
		    break;

		default:
		    printf( "action # %d\n", zz_act );
		    YY_FATAL_ERROR( "fatal flex scanner internal error" );
		}

	    break; /* exit bogus while loop */
	    }
	}
    }


/* zz_get_next_buffer - try to read in new buffer
 *
 * synopsis
 *     int zz_get_next_buffer();
 *     
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH - 
 *     EOB_ACT_RESTART_SCAN - restart the scanner
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int zz_get_next_buffer()

    {
    register char *dest = zz_ch_buf;
    register char *source = zztext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;
    
    if ( zz_c_buf_p != &zz_ch_buf[zz_n_chars + 1] )
	{
	YY_FATAL_ERROR( "NULL in input" );
	/*NOTREACHED*/
	}

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = zz_c_buf_p - zztext;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( zz_eof_has_been_seen )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	zz_n_chars = 0;

    else
	{
	int num_to_read = YY_BUF_SIZE - number_to_move - 1;

	if ( num_to_read > YY_READ_BUF_SIZE )
	    num_to_read = YY_READ_BUF_SIZE;

	/* read in more data */
	YY_INPUT( (&zz_ch_buf[number_to_move]), zz_n_chars, num_to_read );
	}

    if ( zz_n_chars == 0 )
	{
	if ( number_to_move == 1 )
	    ret_val = EOB_ACT_END_OF_FILE;
	else
	    ret_val = EOB_ACT_LAST_MATCH;

	zz_eof_has_been_seen = 1;
	}

    else
	ret_val = EOB_ACT_RESTART_SCAN;

    zz_n_chars += number_to_move;
    zz_ch_buf[zz_n_chars] = YY_END_OF_BUFFER_CHAR;
    zz_ch_buf[zz_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* zztext begins at the second character in
     * zz_ch_buf; the first character is the one which
     * preceded it before reading in the latest buffer;
     * it needs to be kept around in case it's a
     * newline, so zz_get_previous_state() will have
     * with '^' rules active
     */

    zztext = &zz_ch_buf[1];

    return ( ret_val );
    }


/* zz_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     zz_state_type zz_get_previous_state();
 */

static zz_state_type zz_get_previous_state()

    {
    register zz_state_type zz_current_state;
    register char *zz_cp;

    register char *zz_bp = zztext;

    zz_current_state = zz_start;
    if ( zz_bp[-1] == '\n' )
	++zz_current_state;

    for ( zz_cp = zztext; zz_cp < zz_c_buf_p; ++zz_cp )
	{
	register char zz_c = zz_ec[*zz_cp];
	if ( zz_accept[zz_current_state] )
	    {
	    zz_last_accepting_state = zz_current_state;
	    zz_last_accepting_cpos = zz_cp;
	    }
	while ( zz_chk[zz_base[zz_current_state] + zz_c] != zz_current_state )
	    {
	    zz_current_state = zz_def[zz_current_state];
	    if ( zz_current_state >= 205 )
		zz_c = zz_meta[zz_c];
	    }
	zz_current_state = zz_nxt[zz_base[zz_current_state] + zz_c];
	}

    return ( zz_current_state );
    }


#ifdef __STDC__
static void zzunput( int c, register char *zz_bp )
#else
static void zzunput( c, zz_bp )
int c;
register char *zz_bp;
#endif

    {
    register char *zz_cp = zz_c_buf_p;

    *zz_cp = zz_hold_char; /* undo effects of setting up zztext */

    if ( zz_cp < zz_ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = zz_n_chars + 2; /* +2 for EOB chars */
	register char *dest = &zz_ch_buf[YY_BUF_SIZE + 2];
	register char *source = &zz_ch_buf[number_to_move];

	while ( source > zz_ch_buf )
	    *--dest = *--source;

	zz_cp += dest - source;
	zz_bp += dest - source;

	if ( zz_cp < zz_ch_buf + 2 )
	    YY_FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( zz_cp > zz_bp && zz_cp[-1] == '\n' )
	zz_cp[-2] = '\n';

    *--zz_cp = c;

    YY_DO_BEFORE_ACTION; /* set up zztext again */
    }


static int input()

    {
    int c;
    char *zz_cp = zz_c_buf_p;

    *zz_cp = zz_hold_char;

    if ( *zz_c_buf_p == YY_END_OF_BUFFER_CHAR )
	{ /* need more input */
	zztext = zz_c_buf_p;
	++zz_c_buf_p;

	switch ( zz_get_next_buffer() )
	    {
	    /* this code, unfortunately, is somewhat redundant with
	     * that above
	     */
	    case EOB_ACT_END_OF_FILE:
		{
		if ( zzwrap() )
		    {
		    zz_c_buf_p = zztext;
		    return ( EOF );
		    }

		zz_ch_buf[0] = '\n';
		zz_n_chars = 1;
		zz_ch_buf[zz_n_chars] = YY_END_OF_BUFFER_CHAR;
		zz_ch_buf[zz_n_chars + 1] = YY_END_OF_BUFFER_CHAR;
		zz_eof_has_been_seen = 0;
		zztext = zz_c_buf_p = &zz_ch_buf[1];
		zz_hold_char = *zz_c_buf_p;

		return ( input() );
		}
		break;

	    case EOB_ACT_RESTART_SCAN:
		zz_c_buf_p = zztext;
		break;

	    case EOB_ACT_LAST_MATCH:
		YY_FATAL_ERROR( "unexpected last match in input()" );
	    }
	}

    c = *zz_c_buf_p;
    zz_hold_char = *++zz_c_buf_p;

    return ( c );
    }


#ifdef __STDC__
static void zzrestart( FILE *input_file )
#else
static void zzrestart( input_file )
FILE *input_file;
#endif

    {
    if ( zzin != stdin )
	fclose( zzin );

    zzin = input_file;
    zz_init = 1;
    }
# line 77 "vload.l"


char *zval()
{
	char *cp;

	/* printf(":: '%s'\n", zztext); */

	for(cp = zztext; *cp != ':'; cp++) ;
	cp++;
	while(*cp == ' ' || *cp == '\t') cp++;

	return cp;
}

void cv_armr(val, d)
char *val;
Vdesc *d;
{
	int i;

	for (i = 0; i < sizeof(armor_stat)/sizeof(Armor_stat); i += 1) {
		if (!strcmp(armor_stat[i].type, val)) {
			d->armor.type = i;
			return;
		}
	}

	fprintf(stderr, "Invalid Armor Type : %s\n", val);
	iGblRetCode = DESC_BAD_FORMAT;
}

void cv_body(val, d)
char *val;
Vdesc *d;
{
	int i;

	for (i = 0; i < sizeof(body_stat)/sizeof(Body_stat); i += 1) {
		if (!strcmp(body_stat[i].type, val)) {
			d->body = i;
			return;
		}
	}

	fprintf(stderr, "Invalid Body Type : %s\n", val);
	iGblRetCode = DESC_BAD_FORMAT;
}

void cv_bump(val, d)
char *val;
Vdesc *d;
{
	int i;

	for (i = 0; i < sizeof(bumper_stat)/sizeof(Bumper_stat); i += 1) {
		if (!strcmp(bumper_stat[i].type, val)) {
			d->bumpers = i;
			return;
		}
	}

	fprintf(stderr, "Invalid Bumper Type : %s\n", val);
	iGblRetCode = DESC_BAD_FORMAT;
}

void cv_engine(val, d)
char *val;
Vdesc *d;
{
	int i;

	for (i = 0; i < sizeof(engine_stat)/sizeof(Engine_stat); i += 1) {
		if (!strcmp(engine_stat[i].type, val)) {
			d->engine = i;
			return;
		}
	}

	fprintf(stderr, "Invalid Engine Type : %s\n", val);
	iGblRetCode = DESC_BAD_FORMAT;
}

void cv_special(val, d)
char *val;
Vdesc *d;
{
	int i;

	for (i = 0; i < sizeof(special_stat)/sizeof(Special_stat); i += 1) {
		if (!strcmp(special_stat[i].type, val)) {
			d->specials |= 1 << i;
			return;
		}
	}
	fprintf(stderr, "Unknown Special Type : %s\n", val);
	iGblRetCode = DESC_BAD_FORMAT;
}

void cv_susp(val, d)
char *val;
Vdesc *d;
{
	int i;

	for (i = 0; i < sizeof(suspension_stat)/sizeof(Suspension_stat); i += 1) {
		if (!strcmp(suspension_stat[i].type, val)) {
			d->suspension = i;
			return;
		}
	}
	fprintf(stderr, "Invalid Suspension Type : %s\n", val);
	iGblRetCode = DESC_BAD_FORMAT;
}

void cv_tread(val, d)
char *val;
Vdesc *d;
{
	int i;

	for (i = 0; i < sizeof(tread_stat)/sizeof(Tread_stat); i += 1) {
		if (!strcmp(tread_stat[i].type, val)) {
			d->treads = i;
			return;
		}
	}
	fprintf(stderr, "Invalid Tread Type : %s\n", val);
	iGblRetCode = DESC_BAD_FORMAT;
}

void cv_weap(weapon_num, val, d)
char weapon_num;
char *val;
Vdesc *d;
{
	char *ptr = val;

	while (! isspace(*ptr) && *ptr)
	{
		ptr++;
	}
	*ptr = '\0';

	ptr++;
	while (isspace(*ptr) && *ptr)
	{
		ptr++;
	}

	if (*ptr)
	{
		cv_kw2i(val, &d->mount[d->num_weapons], Mnames, NUM_MOUNTS);
		cv_kw2i(ptr, &d->weapon[d->num_weapons], Wnames, VMAX_WEAPONS);
		d->num_weapons += 1;
	}
	else
	{
		iGblRetCode = DESC_BAD_FORMAT;
	}

	return;
}

int ReadVehicleFormat1(fp, d)
	FILE *fp;
	Vdesc *d;
{
	static int bCalled = FALSE;
	iGblRetCode = DESC_LOADED;

	if (bCalled) {
		zzrestart(fp);
		zzlex(d);
	} else {
		if (Wnames[0] == (void *)0)
		{
			init_Wnames();
		}

		zzin = fp;
		zzlex(d);

		bCalled = TRUE;
	}

	return (iGblRetCode);
}
