#include <assert.h>
#define Object XObject
#include <Xm/Xm.h>
#undef XObject
#include "UIComponent.h"


static void widgetDestroyedCallback(Widget w,XtPointer clientData,XtPointer call_data)
{
  UIComponent *obj = (UIComponent *) clientData;
  [obj widgetDestroyed];
}






@implementation UIComponent
+ initialize
{
	return self;
}


- widgetDestroyed
{
  _w = NULL;
}



- manage
{
  assert ( _w != NULL );
  assert ( XtHasCallbacks ( _w, XmNdestroyCallback ) ==
	  XtCallbackHasSome );
  XtManageChild ( _w );
  return self;
}

- installDestroyHandler
{
  assert ( _w != NULL );
  XtAddCallback ( _w,
		 XmNdestroyCallback,
		 widgetDestroyedCallback,
		 (XtPointer) self );

  return self;
}

 
- init
{
  [super init];
//  [self installDestroyHandler];
  return self;
}




- free
{
  // Make sure the widget hasn't already been destroyed
  if ( _w )
    {
      // Remove destroy callback so Xt can't call the callback
      // with a pointer to an object that has already been freed
      
      XtRemoveCallback ( _w,
			XmNdestroyCallback,
			widgetDestroyedCallback,
			(XtPointer) self );
    }
  [super free];
}



- getResources:(const XtResourceList) resources count:(const int) numResources 
{
    // Check for errors
    
    assert ( _w != NULL );
    assert ( resources != NULL );
    
    // Retrieve the requested resources relative to the 
    // parent of this object's base widget
    
    XtGetSubresources ( XtParent( _w ), 
		       (XtPointer) self, 
		       _name,
		       [self name],
		       resources, 
		       numResources,
		       NULL, 
		       0 );
    return self;
}


- setDefaultResources:(const String *)resourceSpec
{
    int         i;	
   Display    *dpy = XtDisplay ( _w );	  // Retrieve the display pointer
   XrmDatabase rdb = NULL;             // A resource data base

   // Create an empty resource database

   rdb = XrmGetStringDatabase ( "" );

   // Add the Component resources, prepending the name of the component

   i = 0;
   while ( resourceSpec[i] != NULL )
   {
       char buf[1000];

       sprintf(buf, "*%s%s", _name, resourceSpec[i++]);
       XrmPutLineResource( &rdb, buf );
   }

   // Merge them into the Xt database, with lowest precendence

   if ( rdb )
   {
#if (XlibSpecificationRelease>=5)
        XrmDatabase db = XtDatabase(dpy);
	XrmCombineDatabase(rdb, &db, FALSE);
#else
        XrmMergeDatabases ( dpy->db, &rdb );
        dpy->db = rdb;
#endif
    } 

  return self;
}


@end
