
#include "ObjCCallback.h"


typedef struct _ObjCCallbackStruct {
  id target;
  id sender;
  SEL msg;
  XtPointer data; // the real client data
} ObjCCallbackStruct;


void ObjCCallbackFunc(Widget w, XtPointer clientdata, XtPointer calldata)
{	
  // the client data has the objc info in it
  ObjCCallbackStruct *d=(ObjCCallbackStruct*)clientdata;
  // should be freed in callback msg 
  id dObjC=[[ObjCCallback new] init:d->data  callData:calldata sender:d->sender]; 
  
  if(d->target!=nil && [d->target respondsTo:d->msg])
    [d->target perform:d->msg with:dObjC];
}

void ObjCAddCallback(Widget w, String name, XtPointer d, id s, id target, SEL msg)
{
  ObjCCallbackStruct *cs=(ObjCCallbackStruct*)XtMalloc(sizeof(ObjCCallbackStruct));

  cs->target=target; cs->msg=msg; cs->data=d; cs->sender=s;
  XtAddCallback(w,name,ObjCCallbackFunc,cs);
}

void ObjCRemoveCallback(Widget w, String name, XtPointer d, id s, id target, SEL msg)
{
  ObjCCallbackStruct *cs=(ObjCCallbackStruct*)XtMalloc(sizeof(ObjCCallbackStruct));

  cs->target=target; cs->msg=msg; cs->data=d; cs->sender=s;

  XtRemoveCallback(w,name,ObjCCallbackFunc,cs);
}




@implementation ObjCCallback

- sender
{
  return sender;
}
- init:(XtPointer)newClientData callData:(XtPointer)newCallData sender:s
{
  clientData = newClientData;
  callData = newCallData;
  sender = s;
  return self;
}
- (XtPointer)clientData
{
  return clientData;
}
- (XtPointer)callData;
{
  return callData;
}
@end
