#include <assert.h>
#include <stdio.h>

#define Object XObject
#include <X11/Intrinsic.h>
#undef Object

#include "BasicComponent.h"


// destroy with XtDestroyWidget(_w)

@implementation BasicComponent
+ initialize  
{
  return self;
}
+ new:(const char*)name
{
  id obj=[super new];
  [obj xname:name];
  return obj;
}

+ new
{
  return [self new:"Blah"];
}

- init:(const char*)name
{
  [self xname:name];
  return self;
}

- init
{
  return self;
}

- (Widget)baseWidget
{
  return _w;
}

- manage
{
  assert(_w!=NULL);
  XtManageChild(_w);
  return self;
}

- unmanage
{
  assert ( _w != NULL );	
  XtUnmanageChild ( _w );	
  return self;	
}

- (const char*)xname { return _name; }
- xname:(const char*)newName 
{ 
  XtFree(_name);  
  _name = XtMalloc((strlen(newName)+1)*sizeof(char));
  strcpy(_name,newName);
  return self; 
}	



@end
