#include <assert.h>

#define Object XObject
#include <X11/Intrinsic.h>
#include <Xm/Label.h>
#include <Xm/MainW.h>
#undef Object

#include "List.h"


#include "Application.h"

Application *XApp=NULL;


@implementation Application


- init:(unsigned int *) argcp :(char**) argv
{
  String fallbacks[]={NULL};
  [self init:argcp :argv :fallbacks];
  return self;
}

- init:(unsigned int *) argcp :(char**) argv :(String *)fallbacks
{
  delegate = nil;

  _w = XtAppInitialize ( &_appContext, 
			_name, NULL, 0, 
			argcp, argv, 
			fallbacks, NULL, 0 );
  
  // Extract and save a pointer to the X display structure
  
  _display = XtDisplay ( _w );
  
  // The Application class is less likely to need to handle
  // "surprise" widget destruction than other classes, but
  // we might as well install a callback to be safe and consistent
  
  [super installDestroyHandler];
  
  // Center the shell, and make sure it isn't visible
  
  XtVaSetValues ( _w,
		   XmNmappedWhenManaged, FALSE,
		 XmNx, DisplayWidth ( _display, 0 ) / 2,
		 XmNy, DisplayHeight ( _display, 0 ) / 2,
		 XmNwidth,  1,
		 XmNheight, 1,
		 NULL );
  
  // The instance name of this object was set in the UIComponent 
  // constructor, before the name of the program was available
  // Free the old name and reset it to argv[0]
  
  [self xname: argv[0]];
  
  
  // Force the shell window to exist so dialogs popped up from
  // this shell behave correctly
  
  XtRealizeWidget ( _w );

  [self appDidInit];
  if(delegate!=nil && [delegate respondsTo:@selector(appDidInit)])
    [delegate appDidInit];
  mainWindow = nil;
windowList = [[List alloc] init];
  return self;
}

- registerWindow:o
{
    [windowList push:o];
    return self;
}

- removeFromWindowList:o
{
    [windowList removeObject:o];
    return self;
}


- makeKeyAndOrderFront: w
{
  [w manage];
  return self;
}

- help: sender
{
  return self;
}

- unhide: sender
{
  return self;
}
-hide: sender
{ 
  return self;
}
- quit: sender
{
  return self;
}

- run
{
  XtAppMainLoop(_appContext);
  return self;
}


- appDidInit
{
  
  return self;
}


- delegate:del { delegate=del; return self;}
- delegate { return delegate; }

- (Display*)display
{
	return _display;
}

- (int)displayWidth
{
  return DisplayWidth(_display,0);
} 

- (int)displayHeight
{
  return DisplayHeight(_display,0);
}

-(Screen*)screen
{
  return XtScreen(_w);
}
- destroyAppContext
{
  XtDestroyWidget(_appContext);
  return self;
}


- mainWindow:o
{
    mainWindow = o;
    return self;
}


- free
{
    int j=[windowList count];

    while(j--)
    {
	[[windowList objectAt:j] close];
    }

    [super free];
    return self;
} 

@end




