 static char rcsid[] = "$Id: parser.c,v 1.1.1.1 1992/01/10 18:30:51 jtsillas Exp $";

/*****************************************************************************
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *  Copyright 1990 Thomson Consumer Electronics, Inc.
 *  Copyright 1991 Bull HN Worldwide Info Systems, Inc.
 *
 *****************************************************************************/

/*  parser.c:
 *
 *    Parse output messages from gdb using regular expression pattern matching,
 *    and take appropriate action.
 *
 *    compile():	Compile the regular expressions in a table (static).
 *    match():		Try to best match a given string with the regular
 *			expressions found in the table and return an index.
 *    parser_init():	Initialization.
 */

#include	"global.h"
#include	"regex.h"
#include	"gdb_regex.h"

#define BYTEWIDTH       8
#define RE_BUFFER       100

static void compile(PatternRec*);

Tokens 	Token;			/* gloabl token structure */
Boolean	Parse = True;		/* Parse flag for parse routine */

/*
 *  Compile all the regular expression patterns in a pattern table.
 *  A pattern table is an array of pattern records.
 *  Each pattern record consists of a regular
 *  expression, a buffer for the to-be-compiled regular expression,
 *  and an array to associate a given token with a matched register number.
 */
static void compile(patternTable)
PatternRec *patternTable;
{
    PatternRec	*p;
    char 	fastmap[(1 << BYTEWIDTH)];
    int		i;

    for (i=0; patternTable[i].pat; i++) {
	p = &patternTable[i];
	p->buf = (struct re_pattern_buffer *) 
	  XtMalloc (sizeof (struct re_pattern_buffer));
	p->buf->allocated = RE_BUFFER;
	p->buf->buffer = (char *) XtMalloc (p->buf->allocated);
	p->buf->fastmap = fastmap;
	p->buf->translate = NULL;
	re_compile_pattern(p->pat, strlen(p->pat), p->buf);
	re_compile_fastmap(p->buf);
    }
} 

/*
 *  This routine tries to match a given string with each regular 
 *  expression in a given pattern table.  The best match is found, and
 *  the function returns an index to the pattern table.
 */
int match(patternTable, string, type)
    PatternRec 	*patternTable;
    char 	*string;
    int		type;
{
  struct re_registers	regs;
  int			m, bestmatch = -1, index = -1, i, j, r, start, n;
  char 		*s;
  
  if (!strcmp(string, "")) return -1;
  for (i=0; patternTable[i].pat; i++) 
    {
      if (type != C_ANY && type != i)
	continue;
      m = re_match(patternTable[i].buf, string, strlen(string), 0, &regs);
      if (m == -2 ) 
	{		/* match error - failure stack overflow */
	  fprintf(stderr, "mxgdb error: regular expression matching failed (failure stack overflow)\n");
	  return (-1);
	}
      if (m > bestmatch) 
	{
	  bestmatch = m;
	  index = i;
	  /* for GDB, free memory (if not done earlier) */
	  XtFree(Token.mesg);
	  XtFree(Token.file);
	  XtFree(Token.func);
	  XtFree(Token.display);
	  Token.mesg = Token.file = Token.func = Token.display = NULL;
	  Token.line = Token.stop = 0;
	  for (j=0; j<NTOKENS; j++) 
	    {
	      if ((r = patternTable[i].reg_token[j]) >= 0) 
		{
		  start = regs.start[r];
		  if ((n = regs.end[r] - start) > 0) 
		    {
		      /* The following error could happen if the pattern 
			 table is not correct,
			 better test it here.. */
		      
		      if ( n > strlen(string))
			{
			  /* Something is wrong here ! */
			  fprintf(stderr,
				  "Error match() : n = %d is too big\n",n);
			  n = 0;
			}
		      s = (char *) XtMalloc ((n+1) * sizeof(char));
		      strncpy(s, string+start, n);
		      s[n] = '\0';
		      switch (j) 
			{
			case TK_MESG: Token.mesg = s; break;
			case TK_STOP: Token.stop = atoi(s); XtFree(s); break;
			case TK_FUNC: Token.func = s; break;
			case TK_LINE: Token.line = atoi(s); XtFree(s); break;
			case TK_FILE: Token.file = s; break;
			case TK_DISP: Token.display = s; break;
			}
		    }
		}
	    }
	}
    }
  return index;
}

/* Compile the regular expressions in the output and 
 * command pattern tables. 
 */

void parser_init()
{
    compile(output_pattern);
    compile(command_pattern);
}

