/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
/* 
	text.c
*/

#include "main.h"
#include "text.h"
#include "dialog.h"
#include "nobug.h"

extern Display *dpy;
extern char *progname;
extern Window mixwin;
extern unsigned long myfg, mybg;
extern char canvas_font[128];

int
text_Show(tw)
Mv_text *tw;
{
	XMapRaised(tw->dpy, tw->frame);
	return 1;
}

int
char_proc(tw, c)
Textsw *tw;
char c;
{
	return TRUE;
}

void
text_Destroy(tw)
Mv_text *tw;
{
	textsw_destroy(tw->twin);
	XDestroyWindow(tw->dpy, tw->frame);
	cfree((char *) tw);
}

Mv_text *
new_textwin(filename, width, height, exit_proc)
char *filename;
unsigned width, height;
int (*exit_proc)();
{
	Mv_text *mt;
	XSetWindowAttributes xswa;
	Window parent;
	unsigned bw = 2;
	int char_proc(), lines;
	int x, y;
	get_win_coords(mixwin, &x, &y); /* get position relative to root */
	mt = (Mv_text *) mv_alloc(sizeof(Mv_text));
	mt->dpy = dpy;
	parent = DefaultRootWindow(mt->dpy);
	mt->frame = new_window(parent, width, height, x+100, y+100, bw, 0);
        XStoreName(mt->dpy, mt->frame, filename);
	XSetIconName(mt->dpy, mt->frame, filename);
	if((mt->twin = textsw_create(progname, mt->dpy, mt->frame, 
			LXT_INPUTFILE, filename,
			LXT_OUTPUTFILE, filename,
			LXT_FOREGROUND, myfg,
			LXT_BACKGROUND, mybg,
			LXT_FONT, canvas_font,
			LXT_CHARPROC, char_proc,
			LXT_EXITPROC, exit_proc,
			LXT_NULL)) == (Textsw *) NULL)
		mv_die(errno, "new_textwin:  unable to create text subwindow.");
	mt->Show = text_Show;
	mt->Destroy = text_Destroy;
	lines = *((int *) textsw_get(mt->twin, LXT_NUMLINES));
	textsw_set(mt->twin, LXT_DRAWCURSOR, TRUE,
				LXT_CURSORLINE, lines - 1,
				LXT_CURSORCOLUMN, 80,
				LXT_DRAWCURSOR, TRUE,
				LXT_CURSORVIEWABLE,
				/* lxt obj contains ptr to Mv_text obj */
				LXT_CLIENTDATA, (char *) mt,
				LXT_NULL);
	return mt;
}

Mv_text *twin;

int
edit_text(filename)
char *filename;
{
	int save_sfcomment();
	unsigned width = 500, height = 200;
	int ret_val = 1;
	twin = new_textwin(filename, width, height, save_sfcomment);
	if(twin->Show(twin) < 0) ret_val = -1;
	return ret_val;
}

int
save_sfcomment(tw, disp, edflag)
Textsw *tw;
Display *disp;
int edflag;
{
	char *tempname = (char *) textsw_get(tw, LXT_OUTPUTFILE);
	char comment[MAXCOMM], backupname[37];
	int tfd, comlen, code = NO;
	Mv_text *mvt;
	if(edflag) {
		code = dialog->call(dialog, D_COMCLOSE, "");
		if(code == YES) return 0;	/* go back and save */
	}
	if(code != CANCEL) {	/* go ahead and use whatever already saved */
		sprintf(backupname, "%s%%", tempname);
		if((tfd = open(tempname,O_RDWR,0644)) < 0) {
			mv_error(errno, "Cannot open temp comment file.");
			goto done;
		}
		if((comlen = read_file(tfd, comment, MAXCOMM)) < 0) {
			mv_alert("Cannot read temp comment file.");
			goto done;
		}
		set_comment(comment, comlen);
	}
done:	close(tfd);
	unlink(tempname);
	unlink(backupname);
	/* retrieve pointer to enclosing object and destroy it */
	mvt = (Mv_text *) textsw_get(tw, LXT_CLIENTDATA);
	if(mvt) mvt->Destroy(mvt);
	return 1;
}

int
read_file(fd, buff, maxbytes)
int fd, maxbytes;
char *buff;
{
	register int nchars = 0;
	while((read(fd, buff++, 1) > 0)) {
		if(++nchars >= maxbytes) break;
	}
	if(!nchars) {
		mv_alert("read_file: read error on comment file.");
		return -1;
	}
	return nchars;
}

