/*
	soundfile.c
*/

#include "main.h"
#include "dialog.h"
#include "soundfile.h"
#include "debug.h"
#ifdef sparc
#include <alloca.h>
#endif

extern sf_struct *v;

double tablei();
double array[SIZE];
int lineset;
double tabs[2];			/* for tablei */

tab_set(es)	/* set up table array for curves */
ebuf_struct *es;
{
	/* calculate duration in seconds */

	register int j;
	double dur = (double) es->nsamps/v->srate;
	tableset(dur, SIZE, tabs);    /* set up table for amp */

	if(!lineset) 	/* if no curve entered, fill table with 1's */
	{
		for(j = 0; j < SIZE; j++) array[j] = 1;
	}
}

mv_remove(b)
ebuf_struct *b;
{
	register int i, j;
	double outbox[SF_MAXCHAN];
	sfreset();	/* sets the sfpointer incrementors to 0 */

	for(i=0; i<b->nsamps; i++)
	{
		for(j=0; j<b->nchans; j++) outbox[j] = 0.0;
		PUTSAMP(b, outbox);				
	}
}

unsigned
replace_set(es)
ebuf_struct *es;
{
	int newbufsize, ncopies;
	if(dialog->call(dialog, D_QREPLACE, "") < 1) return 0;
	es->p[0] = dialog->getValue(dialog, 0);
	ncopies = dialog->getValue(dialog, 1);
	if(dialog->getChoice(dialog, 0)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	newbufsize = es->bufsize * ncopies;
	es->nsamps = newbufsize/(es->size*es->nchans); /* set nsamps */
	tab_set(es);
	return (unsigned) newbufsize;
}
#if 0
mv_replace(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	register int i, j, k = 0, z = b->srate/8000;
	double outbox[SF_MAXCHAN], inbox[SF_MAXCHAN];
	double amp;
	sfreset();	/* sets the sfpointer incrementors to 0 */
	z = z ? z : 1;

	for(i=0; i<b->nsamps; i++)
	{
		GETSAMP(a, inbox);
		if(!k--) {
			amp = tablei((long) i,array,tabs) * b->p[0];
			k = z;
		}
		for(j=0; j<b->nchans; j++) outbox[j] = inbox[j] * amp;
		PUTSAMP(b, outbox);				
	}
}
#else
typedef struct {
	int k;
	int z;
	double q;
	double amp;
} replace_s;

static double replace_f(i, src, dest, arg)
int i;
double src, dest;
void *arg;
{
	replace_s *p = (replace_s *)arg;
	if(!p->k--) {
		p->amp = tablei((long) i,array,tabs) * p->q;
		p->k = p->z;
	}
	return src * p->amp;
}

mv_replace(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	replace_s arg; arg.k = 0; arg.z = b->nchans * b->srate/8000;
		  arg.q = b->p[0];
	process(a, b, replace_f, &arg);
}
#endif

unsigned
insplice_set(es)
ebuf_struct *es;
{
	int ncopies, newbufsize;
	if(dialog->call(dialog, D_QSPLICE, "") < 1) return 0;
	es->p[0] = dialog->getValue(dialog, 0);
	ncopies = dialog->getValue(dialog, 1);
	if(dialog->getChoice(dialog, 0)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	newbufsize = es->bufsize * ncopies;
	es->nsamps = newbufsize/(es->size*es->nchans); /* set nsamps */
	tab_set(es);
	return (unsigned) newbufsize;
}

unsigned
mix_set(es)
ebuf_struct *es;
{
	int ncopies, newbufsize;
	if(dialog->call(dialog, D_QMIX, "") < 1) return 0;
	es->p[0] = dialog->getValue(dialog, 0);
	ncopies = dialog->getValue(dialog, 1);
	if(dialog->getChoice(dialog, 0)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	newbufsize = es->bufsize * ncopies; /* new size for mult */
	es->nsamps = newbufsize/(es->size*es->nchans); /* set nsamps */
	tab_set(es);
	return (unsigned) newbufsize;
}

#if 0
mv_mix(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	register int i, j, k = 0, z = b->srate/8000;
	double outbox[SF_MAXCHAN], inbox[SF_MAXCHAN];
	double amp;

	sfreset();	/* sets the sfpointer incrementors to 0 */

	for(i=0; i<b->nsamps; i++)
	{
		GETSAMP(a, inbox);
		if(!k--) {
			amp = tablei((long) i,array,tabs) * b->p[0];
			k = z;
		}
		for(j=0; j<b->nchans; j++) outbox[j] = inbox[j] * amp;
		ADDSAMP(b, outbox);				
	}
}
#else
typedef struct {
	int k;
	int z;
	double q;
	double amp;
} mix_s;

static double mix_f(i, src, dest, arg)
int i;
double src, dest;
void *arg;
{
	mix_s *p = (mix_s *)arg;
	if(!p->k--) {
		p->amp = tablei((long) i,array,tabs) * p->q;
		p->k = p->z;
	}
	return dest + src * p->amp;
}

mv_mix(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	mix_s arg; arg.k = 0; arg.z = b->nchans * b->srate/8000;
		  arg.q = b->p[0];
	process(a, b, mix_f, &arg);
}
#endif

unsigned
mult_set(es)
ebuf_struct *es;
{
	if(dialog->call(dialog, D_QMULT, "") < 1) return 0;
	es->p[0] = dialog->getValue(dialog, 0);
	es->nsamps = es->bufsize/(es->size*es->nchans); /* set nsamps */
	if(dialog->getChoice(dialog, 0)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}
	tab_set(es);
	return es->bufsize;
}

#if 0
mv_mult(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	register int i, j;
	double outbox[SF_MAXCHAN], inbox[SF_MAXCHAN], inbox2[SF_MAXCHAN];
	register double amp = b->p[0];

	sfreset();	/* sets the sfpointer incrementors to 0 */

	for(i=0; i<b->nsamps; i++)
	{
		GETSAMP(a, inbox);
		GETSAMP(b, inbox2);
		for(j=0; j<b->nchans; j++) outbox[j] = inbox[j]*amp*inbox2[j];
		PUTSAMP(b, outbox);				
	}
}
#else
static double mult_f(i, src, dest, arg)
int i;
double src, dest;
void *arg;
{
	return src * *(double *)arg * dest;
}

mv_mult(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	process(a, b, mult_f, &b->p[0]);
}
#endif

unsigned
cfade_set(es)
ebuf_struct *es;
{
	if(dialog->call(dialog, D_QCFADE, "") < 1) return 0;
	es->p[0] = dialog->getValue(dialog, 0);
	es->nsamps = es->bufsize/(es->size*es->nchans); /* set nsamps */
	if(get_curve() < 1) {
		clear_events();
		return 0;
	}
	tab_set(es);
	return es->bufsize;
}

#if 1
mv_cfade(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	register int i, j, k = 0, z = b->srate/8000;
	double outbox[SF_MAXCHAN], inbox[SF_MAXCHAN], inbox2[SF_MAXCHAN];
	double amp1, amp2;
	register double fixamp = b->p[0];

	sfreset();	/* sets the sfpointer incrementors to 0 */

	for(i=0; i<b->nsamps; i++)
	{
		GETSAMP(a, inbox);
		GETSAMP(b, inbox2);
		if(!k--) {
			amp1 = tablei((long) i,array,tabs);
			amp2 = 1.0 - amp1;
			k = z;
		}
		for(j=0; j<b->nchans; j++) 
			outbox[j] = inbox[j]*amp1 + inbox2[j]*amp2*fixamp;
		PUTSAMP(b, outbox);				
	}
}
#else
typedef struct {
	int k;
	int z;
	double q;
	double amp1, amp2;
} cfade_s;

static double cfade_f(i, src, dest, arg)
int i;
double src, dest;
void *arg;
{
	cfade_s *p = (cfade_s *)arg;
	if(!p->k--) {
		p->amp1 = tablei((long) i,array,tabs);
		p->amp2 = 1.0 - p->amp1;
		p->k = p->z;
	}
	return src * p->amp1 + dest * p->amp2 * p->q;
}

mv_cfade(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	cfade_s arg; arg.k = 0; arg.z = b->nchans * b->srate/8000;
		  arg.q = b->p[0];
	process(a, b, cfade_f, &arg);
}
#endif

mv_reverse(b)
ebuf_struct *b;
{
	register int halfsmps = b->nsamps/2;
	register int chunk = b->size*b->nchans;
	char *temp, *start, *end;

	temp = (char *) alloca((unsigned) chunk);
	start = b->sfbuff;
	end = b->sfbuff + b->bufsize - chunk;
	while(halfsmps--)
	{
		bcopy(end, temp, chunk);
		bcopy(start, end, chunk);
		bcopy(temp, start, chunk);
		start += chunk;
		end -= chunk; 
	}
}

mv_rescale(c)
cbuf_struct *c;
{
	register int ch, count = c->bufsize/(c->size*c->nchans);	
	double outbox[SF_MAXCHAN], inbox[SF_MAXCHAN];
	register double rescale = ((v->size==1)?256.0:32767.0)/c->peakamp;
	sfreset();
	while(count--) {
		GETSAMP(c, inbox);
		for(ch=0; ch < c->nchans; ch++) outbox[ch] = inbox[ch]*rescale;
		PUTSAMP(c, outbox);
	}
}

ebuf_struct *
newBuffer(size, srate, nchans) /* creates new buffer */
	int size, srate, nchans;
{
	ebuf_struct *e;
	e = (ebuf_struct *) mv_alloc(sizeof(ebuf_struct));
	e->sfbuff = NULL;
	e->inptr = e->outptr = 0;
	e->nchans = nchans;
	e->srate = srate;
	e->is_float = (size == SF_FLOAT);
	e->size = size;
	e->bufsize = 0;
	e->peakamp = 0.0;
	set_property(e);
	return e;
}

destroyBuffer(es) /* deallocates buffers created with above */
	ebuf_struct *es;
{
	if(es->bufsize) cfree(es->sfbuff);
	cfree((char *) es);
}

ebuf_struct *
copyData(es) /* creates shallow copy of struct (does not copy sound data) */
	ebuf_struct *es;
{
	ebuf_struct *newbuf = newBuffer(SF_SHORT, es->srate, es->nchans);
	*newbuf = *es;	/* copy all params over to new struct */
	return newbuf;
}

int
allocBuffer(e, size) /* allocates space for sound data and sets values */
	ebuf_struct *e;
	int size;
{
	if(!e->bufsize) e->sfbuff = (char *) mv_alloc(size);
	else {
		mv_alert("allocBuffer:  buffer already allocated!");
		return e->bufsize;
	}
	e->bufsize = size;
	e->nsamps = e->bufsize/(e->nchans * e->size);
	return size;
}

ebuf_struct *
copyRescaled(es) /* creates a rescaled short int copy from floats */
	ebuf_struct *es;
{
	short *ptr;
	float *fptr;
	ebuf_struct *newbuf;
	double rescale = 32767.0/es->peakamp;
	int totalsamps = es->nsamps * es->nchans;
	if(!es->is_float) mv_die(0, "copyRescaled:  buffer format not floats!");
	newbuf = newBuffer(SF_SHORT, es->srate, es->nchans);
	allocBuffer(newbuf, (int) (es->bufsize/2.0));
	/* rescale float sound buffer into new buffer */
	ptr = (short *) newbuf->sfbuff;
	fptr = (float *) es->sfbuff;
	while(totalsamps--) *ptr++ = (*fptr++ * rescale) + 0.5;
	return newbuf;
}

floatToShort(es)	/* converts buffer to rescaled shorts */
	ebuf_struct *es;
{
	short *sptr;
	float *fptr, rescale = 32767.0/es->peakamp;
	int tsamps = es->bufsize/es->size;
	fptr = (float *) es->sfbuff;
	sptr = (short *) es->sfbuff;
	while(tsamps--)
		*sptr++ = (short) ((*fptr++ * rescale) + 0.5);
	if((es->sfbuff = (char *) realloc(es->sfbuff, es->bufsize/2)) == CNULL)
		mv_die(errno, "floatToShort:  memory reallocation error.");
	es->size = SF_SHORT;
	es->is_float = FALSE;
	es->bufsize /= 2;
	es->peakamp = 32767.0;
	set_property(es);
}		

shortToFloat(es)	/* converts buffer to floats */
	ebuf_struct *es;
{
	short *sptr;
	float *fptr;
	char *tbuff;
	int tsamps = es->bufsize/es->size;
	sptr = (short *) es->sfbuff;
	tbuff = mv_alloc(es->bufsize*2);
	fptr = (float *) tbuff;
	while(tsamps--)
		*fptr++ = (float) *sptr++;
	cfree(es->sfbuff);
	es->sfbuff = tbuff;
	es->size = SF_FLOAT;
	es->is_float = TRUE;
	es->bufsize *= 2;
	set_property(es);
}		

#ifdef	SOUNDBLASTER

floatToUB(es)	/* converts buffer to unsigned bytes */
	ebuf_struct *es;
{
	unsigned char *bptr;
	float *fptr, rescale = 127.0/es->peakamp;
	int tsamps = es->bufsize/es->size;
	fptr = (float *) es->sfbuff;
	bptr = (unsigned char *) es->sfbuff;
	while(tsamps--)
		*bptr++ = REVERT((*fptr++ * rescale) + 127.5);
	if((es->sfbuff = (char *) realloc(es->sfbuff, es->bufsize/4)) == CNULL)
		mv_die(errno, "floatToUB:  memory reallocation error.");
	es->size = SF_CODEC;
	es->is_float = FALSE;
	es->bufsize /= 4;
	es->peakamp = 255.0;
	set_property(es);
}		

UBToFloat(es)	/* converts unsigned byte buffer to floats */
	ebuf_struct *es;
{
	unsigned char *bptr;
	float *fptr;
	char *tbuff;
	int tsamps = es->bufsize/es->size;
	bptr = (unsigned char *) es->sfbuff;
	tbuff = mv_alloc(es->bufsize*2);
	fptr = (float *) tbuff;
	while(tsamps--)
		*fptr++ = CONVERT((*bptr++) - 127.0);
	cfree(es->sfbuff);
	es->sfbuff = tbuff;
	es->size = SF_FLOAT;
	es->is_float = TRUE;
	es->bufsize *= 4;
	set_property(es);
}		

UBToShort(es)
	ebuf_struct *es;
{
	char *newbuf, *cptr;
	short *ptr, tmp;
	int tsamps = es->bufsize/es->size;
	es->nsamps = tsamps/es->nchans;
	cptr = es->sfbuff;
	newbuf = (char *) mv_alloc(2 * es->bufsize);	/* twice as big */
	ptr = (short *) newbuf;
	while(tsamps--) 
		*ptr++ = CONVERT(*cptr++);
	cfree(es->sfbuff);
	es->sfbuff = newbuf;
	es->size = sizeof(short);
	es->bufsize *= 2;
	set_property(es);
}

ShortToUB(es)
	ebuf_struct *es;
{
	char *newbuf;
	unsigned char *cptr;
	short *ptr;
	int tsamps = es->bufsize/es->size;
	es->nsamps = tsamps/es->nchans;
	newbuf = (char *) mv_alloc(es->bufsize/2);	/* half as big */
	cptr = (unsigned char *) newbuf;
	ptr = (short *) es->sfbuff;
	while(tsamps--) 
		*cptr++ = REVERT(*ptr++);
	cfree(es->sfbuff);
	es->sfbuff = newbuf;
	es->size = sizeof(char);
	es->bufsize /= 2;
	es->peakamp = 256;
	set_property(es);
}

/* creates an 8-bit unsigned SoundBlaster copy from floats or shorts */
ebuf_struct *
copyUB(es) 
	ebuf_struct *es;
{
	unsigned char *ptr;
	float *fptr;
	short *sptr;
	ebuf_struct *newbuf;
	double rescale = 127.0/es->peakamp;
	float val;

	int totalsamps = es->nsamps * es->nchans;
	if(es->size == 1) mv_die(0, "copyUB:  buffer format already UB!");
	newbuf = newBuffer(SF_CODEC, es->srate, es->nchans);
	allocBuffer(newbuf, (int) (es->bufsize/es->size));
	/* rescale sound buffer into new buffer */
	ptr = (unsigned char *) newbuf->sfbuff;
	if(es->is_float) {
		fptr = (float *) es->sfbuff;
		while(totalsamps--) 
			*ptr++ = REVERT((*fptr++ * rescale) + 127.5);
	}
	else {
		sptr = (short *) es->sfbuff;
		while(totalsamps--) {
/*
			val = *sptr++ * rescale;
			val += 127.5;
			*ptr++ = REVERT(val);
*/
			*ptr++ = REVERT(((float) *sptr++ * rescale) + 127.5);
		}
	}
	newbuf->peakamp = 256;
	return newbuf;
}
#endif /* SOUNDBLASTER */

#if NeXT_STYLE_HEADER

muToShort(es)
	ebuf_struct *es;
{
	char *newbuf, *cptr;
	short *ptr, tmp;
	int tsamps = es->bufsize/es->size;
	es->nsamps = tsamps/es->nchans;
	cptr = es->sfbuff;
	newbuf = (char *) mv_alloc(2 * es->bufsize);	/* twice as big */
	ptr = (short *) newbuf;
	while(tsamps--) 
		*ptr++ = CONVERT(*cptr++);
	cfree(es->sfbuff);
	es->sfbuff = newbuf;
	es->size = sizeof(short);
	es->bufsize *= 2;
	set_property(es);
}

shortToMu(es)
	ebuf_struct *es;
{
	char *newbuf;
	unsigned char *cptr;
	short *ptr;
	int tsamps = es->bufsize/es->size;
	es->nsamps = tsamps/es->nchans;
	newbuf = (char *) mv_alloc(es->bufsize/2);	/* half as big */
	cptr = (unsigned char *) newbuf;
	ptr = (short *) es->sfbuff;
	while(tsamps--) 
		*cptr++ = REVERT(*ptr++);
	cfree(es->sfbuff);
	es->sfbuff = newbuf;
	es->size = sizeof(char);
	es->bufsize /= 2;
	es->peakamp = 256;
	set_property(es);
}

ebuf_struct *
copyMuLaw(es) /* creates an 8-bit Mu Law copy from floats or shorts */
	ebuf_struct *es;
{
	unsigned char *ptr;
	float *fptr;
	short *sptr;
	ebuf_struct *newbuf;
	double rescale = 32767.0/es->peakamp;
	int totalsamps = es->nsamps * es->nchans;
	if(es->size == 1) mv_die(0, "copyMuLaw:  buffer format already MuLaw!");
	newbuf = newBuffer(SF_CODEC, es->srate, es->nchans);
	allocBuffer(newbuf, (int) (es->bufsize/es->size));
	/* rescale sound buffer into new buffer */
	ptr = (unsigned char *) newbuf->sfbuff;
	if(es->is_float) {
		fptr = (float *) es->sfbuff;
		while(totalsamps--) 
			*ptr++ = REVERT((*fptr++ * rescale) + 0.5);
	}
	else {
		sptr = (short *) es->sfbuff;
		while(totalsamps--) 
			*ptr++ = REVERT((*sptr++ * rescale) + 0.5);
	}
	newbuf->peakamp = 256;
	return newbuf;
}

#else
/* define as nothing */
#define shortToMu(x)
#define muToShort(x)
#define copyMuLaw(x)
#endif /* NeXT_STYLE_HEADER */

int
is_soundfile(fname, searchmode)
char *fname;
int searchmode;
{
	switch (searchmode) {
	case 0:
		return True;
	case 1: 
		return is_suffix(fname, SUFF);
	case 2:
		 return has_header(fname);
	}
	return True;
}

int
is_suffix(name, suff)	/* checks to see name ends in suffix */
char *name, *suff;
{
	int i, j;
	i = strlen(name) - 1;
	j = strlen(suff) - 1;
	if(i<j) return False;
	while(j-- && i--) if(*(name+i) != *(suff+j)) return False;
	return True;
}

int 
has_header(name)	/* checks for valid magic number */
char *name;
{
	int sfd, magic;
	if((sfd = open(name, O_RDONLY)) > 0)
		if(read(sfd, (char *) &magic, sizeof(int)) == sizeof(int))
			if(magic == HEAD_MAGIC || magic == SF_MAGIC) {
				close(sfd);
				return True;
			}
	close(sfd);
	return False;
}
