/* play.h */

#include <signal.h>

#if defined(SPARC_DACS)
#include <fcntl.h>
#include <stropts.h>
#include <sun/audioio.h>
#include <multimedia/libaudio.h>
#include <multimedia/audio_device.h>
#include "soundfile.h"
#define CONVERT_FORMAT SF_CODEC
typedef audio_info_t STUFF;
#endif /* SPARC_DACS */

#if defined(SOUNDBLASTER)
#include <sys/sb.h>
#define CONVERT_FORMAT SF_CODEC
typedef int STUFF;
#define	DEVICE "/dev/sbdsp"	/* Streams pipe with player */
#define MODE O_WRONLY
#define DEVICE_SET DSP_IOCTL_SPEED
#define BUFLEN 65536
#endif /* SOUNDBLASTER */

#if defined(SPARC_DACS)
#define DEVICE "/dev/audio"
#define MODE O_RDWR|O_NDELAY
#define DEVICE_SET AUDIO_SETINFO
#define MULAW_SRATE 8000
#define BUFLEN 4096
#endif /* SPARC_DACS */

#ifdef NeXT
#include <sound/sound.h>
#define CONVERT_FORMAT SF_SHORT
#define MULAW_SRATE 8012
typedef int STUFF;
#endif /* NeXT */

#ifdef ADC_DACS
#include <adclib.h>
/* #define ADC_BUFLEN (ADC_OUT_BUFFER_LENGTH) */
#define ADC_BUFLEN 8192
#define ADC_BUFSAMPS ((int)(ADC_BUFLEN/2.0))
#define ADC_MINBUFFS (6)
#if !defined(NeXT) && !defined(SOUNDBLASTER) && !defined(SPARC_DACS)
#define CONVERT_FORMAT SF_SHORT
typedef int STUFF;
#endif
#endif	/* ADC_DACS */

#ifdef S56X_DACS
#include "s56dspUser.h"
#include "qckMon.h"
#include "drp.h"
#endif
