/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#include "main.h"
#include <math.h>
#include "nobug.h"

#define PI2 6.2831852

extern sf_struct *v;

double octpch(pch)
double pch;
{
	int oct = pch;
	return(oct + 8.333333 * (pch - oct));
}

double pchoct(oct)
double oct;
{
	double x;
	x = (int)oct;
	return(.12 * (oct - x) + x);
}

double octcps(cps)
double cps;
{
	return(log(cps/1.021975)/.69314718);

	/* .69etc is log of 2., 1.02etc is offset for middle C */
}

double cpsoct(oct)
double oct;
{
	return(pow(2.,oct) * 1.021975);
}

double cpspch(pch)
double pch;
{
	int oct = pch;
	return((pow(2.,oct+8.333333*(pch-oct))*1.021975));
}

double tablei(nsample,array,tab)
long nsample;
double *array,*tab;
{
	register loc1,loc2;
        double frac = ((double)(nsample)/(*tab)) * *(tab+1);
	if(frac >= *(tab+1))  {
		loc1 = *(tab+1);
		loc2 = loc1;
		frac = 0;
		}
	else    {
		loc1 = frac;
		loc2 = loc1+1;
		frac = frac - (double)loc1;
		}
	return(*(array+loc1) + frac * (*(array+loc2) - *(array+loc1)));
}

tableset(dur,size,tab)
double dur,*tab;
int size;
{
	*tab = (long)(dur * v->srate -.9999);
	if(*tab == 0.0) *tab = 1.0;	/* for very short durations */
	*(tab+1) = size - 1;
}

/* rand1 returns floating point values between 0 and 1              */

double 
rand1 (x)
    double *x;
{
	register int n;

	n = *x * 1048576.;
        *x = (double)((1061 * n + 221589) % 1048576)/1048576.;
	return (*x);
}



/* randi produces interpolated linear ramps between successive random
   numbers at a rate determined in a setup routine.                     */

double
randi (a)
    double a[6];
{
    double rand1();

    /* a[0] is the amp.  a[1] is the SI.  a[2] is set to 1.0 externally.
       a[4] is the seed, set externally.                               */

    /* advance counter by fraction of 512 (SI) */

    a[2] += a[1]/512.0;

    /* every time counter exceeds 1.0, calculate new rand # */

    if (a[2] >= 1.0)
    {
	a[2] -= 1.0;                       /* reset counter */
	a[3] = a[4];                       /* store old value */
	a[4] = rand1(a + 4);               /* get new rand val */
	a[5] = 2.0 * (a[3] - a[4]);        /* twice the difference */
	a[3] = 1.0 - (2.0 * a[3]) - (a[5] * a[2]);
    }
    /* output is linear interpolation between old and new, centered around
       zero, and multiplied by the amp factor.                           */

       return ((a[3] + a[5] * a[2]) * a[0]);
}

/* tone is a simple 1st order recursive lowpass filter */

double
tone (sig, data)
    double sig, *data;
{
    data[2] = data[0]*sig + data[1]*data[2];
    return (data[2]);
}



/* toneset calculates the coefficients for tone. cutoff is -3db point in
   cps.  flag will reset history if set to 1.                         */

void
toneset (cutoff, flag, data)
    double cutoff, *data;
    int flag;
{
    double x;

    x = 2.0 - cos(cutoff * PI2 / v->srate);

    data[1] = x - sqrt(x * x - 1.0);         /* feedback coeff. */
    data[0] = 1.0 - data[1];                 /* gain coeff. */

    if (cutoff < 0.0) data[1] *= -1.0;       /* inverse function */

    if (flag) data[2] = 0.0;
}

void
rsnset(cf, bw, scl, flag, a)
double cf, bw;
int scl, flag;
double *a;
{
	float c,temp;
	if(flag) {
		a[4] = 0;
		a[3] = 0;
		}
	a[2] = exp(-PI2 * bw/v->srate);
	temp = 1. - a[2];
	c = a[2] + 1;
	a[1] = 4. * a[2]/c * cos(PI2 * cf/v->srate);
	if(scl == 0) a[0] = 1;
	if(scl == 1) a[0] = sqrt(temp/c*(c*c-a[1]*a[1]));
	if(scl == 2) a[0] = temp*sqrt(1.-a[1]*a[1]/(4.*a[2]));
}

double 
reson(x,a)
double x, *a;
{
	register double temp;
	temp = *a * x + *(a+1) * *(a+3) - *(a+2) * *(a+4);
	*(a+4) = *(a+3);
	*(a+3) = temp;
	return(temp);
}

void
combset(loopt, rvt, a)
double loopt, *a, rvt;
{
	int j;

	a[0] = (3.0 + (loopt * v->srate + .5));
	a[1] = pow(.001, (loopt/rvt));
	for(j = 3; j < (int)*a; j++)  a[j] = 0.0;
	a[2] = 3.0;
}

double 
comb(samp, a)
double samp, *a;
{
	double temp, *aptr;
	if ( a[2] >= (int) a[0]) a[2] = 3.0;
	aptr = a + (int)a[2];
	a[2] += 1; 
	temp = *aptr;
	*aptr = *aptr * a[1] + samp;
	return(temp);
}

/* p0,2,4,6,8,10.. are times, p1,3,5,7,9,11.. are amps, total number of
 * arguments is n_args, result is stuffed into array array of length length
 */

setline(p,n_args,length,array)
double *p,*array;
int n_args, length;
{
	double increm;
	register int i,j,k,points;

	increm = (p[n_args - 2] - p[0])/length;
	for(j=0,i=0; j < (n_args-2); j += 2) {
		points = (int)((p[j+2] - p[j]) / increm +.5);
		if(p[j+2] != p[j]) {
			if(points <= 0) points = 1;
			for(k=0; k < points; k++) {
				array[i++] = ((double)k/(double)points)
					* (p[j+3] - p[j+1]) + p[j+1];
				if(i == length) return;
			}
		}
	}
	i--;
	while(++i < length) array[i] = array[i-1]; 
}

double interp(y_0,y_1,y_2,t)
    register double t, y_0, y_1, y_2;
{
    register double hy_2, hy_0, a, b, c;
    
    a = y_0;
    hy_0 = y_0/2.0;
    hy_2 =  y_2/2.0;
    b = (-3.0 * hy_0) + (2.0 * y_1) - hy_2;
    c = hy_0 - y_1 + hy_2;

    return(a + b*t + c*t*t);
}

double evp(nsample,f1,f2,q)
int nsample;
double *f1,*f2,*q;
{
	register jloc;
	double far = (double)(nsample)/ *q;
	if( far > *(q+1)) {
		jloc = (1. - ((far - *(q+1))/ *(q+4))) * *(q+3);
		return(*(f2+jloc));
		}
	else
		if(far >= *(q+2)) return(1.);
	else	{
		jloc = far * *(q+3)/ *(q+2);
		return(*(f1+jloc));
		}
}

evset(dur,rise,dec,q)
double dur,rise,dec,*q;
{
	rise = (rise > 0.) ? rise : -rise * dur;
	dec = (dec > 0.) ? dec : -dec * dur;
	q[0] = dur * v->srate;
	q[1] = (dur-dec)/dur;
	q[2] = rise/dur;
	q[3] = SIZE;
	q[4] = dec/dur;
}

inrepos(a,samps)
cbuf_struct *a;
int samps;
{
	register long amt = samps * a->nchans + a->inptr;

	a->inptr = amt;		/* reposition inside buffer */
}

outrepos(b,samps)
ebuf_struct *b;
int samps;
{
	register long amt = samps * b->nchans + b->outptr;

	b->outptr = amt;		/* reposition inside buffer */
}

