/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
/*
	mesg.c
*/

#include "main.h"
#include "dialog.h"
#include "mesg.h"
#include "nobug.h"

extern Display *dpy;
extern Window mixwin;
extern char *progname;
extern unsigned long myfg, mybg;
extern FLAG is_visible;

Mesg *mesg;	/* this is global to entire program */

setup_mesg()	/* called by main to initialize mesg */
{
	mesg = new_mesg(mesg);
}

int
mesg_Visible(m)
	Mesg *m;
{
	XWindowAttributes attr;
	XGetWindowAttributes(m->dpy, m->frame, &attr);
	if(attr.map_state == IsUnmapped) return FALSE;
	else return TRUE;
}

void
mesg_MoveFrame(m, x, y, width, height)
	Mesg *m;
	int x, y;
	unsigned width, height;
{
	XMoveResizeWindow(m->dpy, m->frame, x, y, width, height);
}

void
mesg_setText(m, string)
	Mesg *m; 
	char *string;
{
	canvas_clear(m->cnv);
	XDrawString(m->dpy, m->pm, m->gc, 10, 25, string, strlen(string));
}

void
mesg_Show(m)
	Mesg *m;
{
	int x, y;
	unsigned w = MESG_WIDTH, h = MESG_HEIGHT;
	get_win_coords(mixwin, &x, &y);
	m->MoveFrame(m, x+100, y+50, w, h);
	XMapRaised(m->dpy, m->frame);
}

void
mesg_On(m, string)
	Mesg *m;
	char *string;
{
	if(!is_visible) {
		fprintf(stderr, "%s\n", string);
		return;
	}
	if(!m->Visible(m))
		m->Show(m);
	m->setText(m, string);
	canvas_flush(m->cnv);
	clear_events();
}

void
mesg_Off(m)
	Mesg *m;
{
	XUnmapWindow(m->dpy, m->frame);
	clear_events();
}

void
mesg_Destroy(m)
Mesg *m;
{
	XFreeGC(m->dpy, m->gc);
	canvas_destroy(m->cnv);
	XDestroyWindow(m->dpy, m->frame);
	cfree((char *) m);
}

Mesg *
new_mesg(m)
Mesg *m;
{
	XSetWindowAttributes xswa;
	XFontStruct *fs;
	GC newGC();
	char *font, mesg_font[128];
	unsigned width = 200, height = 45;
	m = (Mesg *) mv_alloc(sizeof(Mesg));
	m->dpy = dpy;
	m->frame = new_window(DefaultRootWindow(m->dpy), width, height,
				0, 0, 1, 0);
	xswa.override_redirect= TRUE;
	XChangeWindowAttributes(m->dpy, m->frame, CWOverrideRedirect, &xswa);
	if((m->cnv = canvas_create(progname, m->dpy, m->frame, 
			LXC_WIDTH, MESG_WIDTH, LXC_HEIGHT, MESG_HEIGHT,
			LXC_NULL)) == (Canvas *) NULL)
		mv_die(errno, "new_mesg:  unable to create canvas");
	m->pm = *((Pixmap *) canvas_get(m->cnv, LXC_PIXMAP));
	if((font = XGetDefault(m->dpy, progname, "MesgFont")) == CNULL)
		strcpy(mesg_font, MESG_FONT);
	else strncpy(mesg_font, font, 127);
	if((fs = XLoadQueryFont(m->dpy, mesg_font)) == NULL) {
		char string[80];
		sprintf(string, "new_mesg: display %s cannot find font %s",
				XDisplayString(m->dpy), mesg_font); 
		mv_die(errno, string);
	}
	m->gc = newGC(m->dpy, m->pm, fs->fid, GXxor);
	XFreeFont(m->dpy, fs);
	m->Visible = mesg_Visible;
	m->setText = mesg_setText;
	m->MoveFrame = mesg_MoveFrame;
	m->Show = mesg_Show;
	m->On = mesg_On;
	m->Off = mesg_Off;
	m->Destroy = mesg_Destroy;
	return m;
}
