
/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
/*	menus.h -- the menu header file for mixview.c
*/

#ifdef SYSV
#include <dirent.h>
#define direct dirent
#else
#include <sys/dir.h>
#endif
#include "patchlevel.h"

/* number of menu_items in each menu */

#define NFILEITEMS 9
#define NEDITITEMS 11 
#define NALTERITEMS  5
#define NOPTIONITEMS  3
#define NFILTERITEMS  5

/* menu-state keys */

#define FILE_OPEN	0x01ff
#define FILE_CLOSED	0x0187
#define FILE_NEW	0x01b6

#ifdef HAS_SFCOMMENT
#define HEADER_OPEN	0x003f
#else
#define HEADER_OPEN	0x001f
#endif
#define HEADER_CLOSED	0x0000

#define EDIT_NONE	0x0001
#define EDIT_INSERT	0x1fc1
#define EDIT_REGION	0x003e

#define ALTER_NONE	0x0000
#define ALTER_INSERT	0x0002
#define ALTER_REGION	0x001d

#define FILTER_NONE	0x0000
#define FILTER_REGION	0x0017

#define OPTION_NONE	0x0000

#define ANALYSIS_REGION 0x003e

#define MENU_FONT "-adobe-courier-bold-r-normal--14-*-*-*-*-*-*-*"

typedef struct {	/* menu information structure (stored in CLIENTDATA) */
	int nitems;
} menu_info; 

typedef struct {	/* menu information structure (stored in CLIENTDATA) */
	int cmd;
} menuitem_info; 

/* declarations of all menu processes */

void save_file(), saveto_file(), close_file(), revert_file();
void open_file(), new_file(), insert_space(), set_sf_search();
void set_internal(), set_external(), recall_edit(), select_all();
void set_peak_rescan(), set_quick_display(), rescale(), menu_select();
void do_hist(), do_fft(), change_srate(), change_length(), change_sfcomment();
void set_line_mode(), set_shadow_mode(), set_cursor_line(), set_cursor_cross();
void set_sfname(), set_new_grainsize(), set_screentimes(), change_sfdir();
void print_version(), exit_prog(), display_header(), set_new_scale();
void do_lpc(), do_ptrack(), do_merge(), do_complete(), change_format();
#if (defined(NeXT) || defined(SPARC_DACS)) && defined(ADC_DACS)
void set_dacs();
#endif

Menu *make_dirmenu(), *new_menu();
void add_menuitem(), add_pullright(), set_menu_font(), set_item_state();
Time get_item_time();
int get_item_command();
