/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#include "main.h"
#include "dialog.h"
#include "mesg.h"
#include "nobug.h"

extern sf_struct *v;

float retarr[461];	/* global array for coefficients (from setell_) */

/* local globals for ellipse */

static float xnorm;
static float ps[4][4][10],ca[4][4][10];  /* first dimension is channel */
static int nsects;			/* number of sections */

unsigned
mell_set(b)
ebuf_struct *b;
{
	register int ch;
	float sampr = v->srate;
	float f1, f2, f3, ripple, atten, amp;

	/* f1=passband cutoff; f2=stopband cutoff; f3=0 or bandpass stopband;
   	ripple; attenuation(db); amp 	*/
	/* all args passed in must be converted from doubles to floats */
	if(dialog->call(dialog, D_QMELL, "") < 1) return 0;
	f1 = (float) dialog->getValue(dialog, 0);
	f2 = (float) dialog->getValue(dialog, 1);
	f3 = (float) dialog->getValue(dialog, 2);
	ripple = (float) dialog->getValue(dialog, 3);
	atten = (float) dialog->getValue(dialog, 4);
	amp = (float) dialog->getValue(dialog, 5);
	if(dialog->getChoice(dialog, 0)) {
		if(get_curve() < 1) {
			clear_events();
			return 0;
		}
	}

#if !defined(HAS_F77) && !defined(HAS_F2C)
	mv_alert( "This filter not available on this machine.");
	return 0;
#else
  	setell_(&sampr,&f1,&f2,&f3,&ripple,&atten,retarr,&nsects);
	for( ch = 0; ch < b->nchans; ch++ ) ellpset(retarr, ca[ch], ps[ch]);
	b->p[0] = amp;
	return b->bufsize;
#endif HAS_F77
}

mv_mell(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	register int i, j;
	double ellipse(), input[4], sig[4];
	double amp = b->p[0];

	sfreset();

	for(i=0; i < a->nsamps; i++) {
		GETSAMP(a,input);
		for( j=0; j < a->nchans; j++)
			sig[j] = ellipse(input[j], ca[j], ps[j]) * amp; 
		ADDSAMP(b,sig); 
        }
}

double ellipse(x,C,PS)
double x;
float C[4][10],PS[4][10];
{
	register int m;
	double op;

	for(m=0;m<nsects;m++) {
		op = x + C[0][m] * PS[0][m] + C[2][m] * PS[1][m]
		       - C[1][m] * PS[2][m] - C[3][m] * PS[3][m];
		PS[1][m] = PS[0][m];
		PS[0][m] = x;
		PS[3][m] = PS[2][m];
		PS[2][m] = op;
		x = op;
		}
	return(x*xnorm);
}

static char msg[128];

ellpset(list,C,PS)
float *list;
float C[4][10],PS[4][10];
{
/* the first argument in the list is the number of sections */
/* this is no longer true -- nsects contains number of sections -- BGG */
	
	register int m,i,j;

	i=0;
	for(m=0;m<nsects;m++) {
		for(j=0;j<4;j++)  {    
	        	 C[j][m] = list[i++];
			 PS[j][m] = 0; }
		}
	xnorm = list[i];
	sprintf(msg, "Number of filter sections: %d\n",nsects);
	mesg->On(mesg, msg);
	sleep(1);
	sprintf(msg, "Nrmlztn. factor: %f; No. of terms: %d\n",xnorm,i);
	mesg->On(mesg, msg);
	sleep(1);
}
