#include "main.h"
#include <X11/keysym.h>
#include "cmd.h"

extern CMD command;
extern Window canvas_win;
extern FLAG region, insert, hairmode, box;
extern int xloc, yloc, xend;

kp_select(event)		/* keyboard key typed */
XKeyPressedEvent *event;
{
	char buff[8];
	int count, bufsize = 8;
	KeySym key;
	static int ntimes = 1;
	if(event->window != canvas_win) return;
	count = XLookupString(event, buff, bufsize, &key, NULL);
	buff[count] = 0;
	if(event->state & ControlMask) {	/* keyboard edit commands */
		switch(key) {
		case XK_c:
			command.type = MC_COPY;
			break;
		case XK_r:
			command.type = MC_REMOVE;
			break;
		case XK_x:
			command.type = MC_OUTSPLICE;
			break;
		case XK_e:
			command.type = MC_ERASE;
			break;
		case XK_z:
			command.type = MC_ZAP;
			break;
		case XK_m:
			command.type = MC_MIX;
			break;
		case XK_R:
			command.type = MC_REPLACE;
			break;
		case XK_v:
			command.type = MC_INSPLICE;
			break;
		case XK_M:
			command.type = MC_MULT;
			break;
		case XK_C:
			command.type = MC_CFADE;
			break;
		default:
			break;
		}
		command.time = CurrentTime;
		ntimes = get_ntimes(key, buff);	/* reset typed number total */
		cmd_check(&command);		/* make sure it is legal at this time */
		cmd_select(&command);		/* process command */
		return;
	}
	switch(key) {	/* keyboard display commands, etc. */
	case XK_h:
		if(region) shift_region(-1, -1);
		else if(insert) shift_insert(-ntimes, 0);
		break;
	case XK_j:
		if(hairmode) shift_insert(0, ntimes);
		break;
	case XK_k:
		if(hairmode) shift_insert(0, -ntimes);
		break;
	case XK_l:
		if(region) shift_region(1, 1);
		else if(insert) shift_insert(ntimes, 0);
		break;
	case XK_plus:
	case XK_equal:			/* same key as plus */
		if(region) shift_region(0, 1);
		break;
	case XK_minus:
	case XK_underscore:		/* same key as minus */
		if(region) shift_region(0, -1);
		break;
	case XK_f:
		page_it(0.25);
		break;
	case XK_F:
		page_it((ntimes-1)+0.95);
		break;
	case XK_b:
		page_it(-0.25);
		break;
	case XK_B:
		page_it(-(ntimes-1)-0.95);
		break;
	case XK_BackSpace:
	case XK_Delete:
		if(box & region){
			undraw_box();
			draw_hair(xloc, yloc);
			set_insert_point(xloc, yloc);
		}
		break;
	case XK_space:
		if(box & region){
			undraw_box();
			draw_hair(xend+1, yloc);
			set_insert_point(xend+1, yloc);
		}
		break;
	case XK_S:	/* saving file */
		(void) save_file((Menu *) 0, (Menu_item *) 0);
		break;
	case XK_C:	/* closing file */
		(void) close_file((Menu *) 0, (Menu_item *) 0);
		break;
	case XK_V:	/* version number display */
		(void) print_version((Menu *) 0, (Menu_item *) 0);
		break;
	case XK_Q:	/* shortcut for quittin' */
		(void) quit((Panel *) 0, (Panel_item *) 0);
		break;
	/* some editing features */
	case XK_A:
		(void) select_all((Menu *) 0, (Menu_item *) 0);
		break;
	/* the following four are kbd shortcuts for vert & horiz res. */
	case XK_Left:
		(void) xzoom((Panel *) 0, (Panel_item *) 0);	
		break;
	case XK_Right:
		(void) xunzoom((Panel *) 0, (Panel_item *) 0);
		break;
	case XK_Up:
		(void) yzoom((Panel *) 0, (Panel_item *) 0);
		break;
	case XK_Down:
		(void) yunzoom((Panel *) 0, (Panel_item *) 0);
		break;
	/* shortcut for zoom feature */
	case XK_asciicircum:	/* the "^" char */
		(void) zoom((Panel *) 0, (Panel_item *) 0);
		break;
	case XK_asterisk: /* shortcut for reset feature */
		(void) reset_screen((Panel *) 0, (Panel_item *) 0);
		break;
	case XK_P:	/* keyboard shortcut for playing file */
		(void) play_it((Panel *) 0, (Panel_item *) 0);
		break;
	}
	ntimes = get_ntimes(key, buff);	/* return typed number total */
}

/**************************************************************************/

get_ntimes(key, str)		/* returns current total number typed */
KeySym key;
char *str;
{
	static char total[24];
	static int num = 1;

	if((key >= XK_0) && (key <= XK_9)) {	/* determine new value */
		strcat(total, str);
		num = atof(total);
	}
	else if(key == XK_Shift_L || key == XK_Shift_R);   /* do nothing */
	else {						   /* reset count */
		*total = 0;
		num = 1;
	}
	return num;
}
