/****************************************************************************** 
 *
 *  mixview - X Window System based soundfile editor and processor
 *
 *  Copyright 1989 by Douglas Scott
 *
 *  Author:     Douglas Scott 
 *  Date:       May 1, 1989
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The author makes no representations about
 *  the suitability of this software for any purpose.  
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/
#include "main.h"
#include "dialog.h"
#include "nobug.h"

#define OCTPT	0		/* data modes for increment */
#define LINOCT	1
#define RATIO	2


extern double array[SIZE];	/* for use with setline */
extern int lineset;		/* the flag telling if setline done */
extern double tabs[2];		/* for tablei */
double bevfun[SIZE];
double q[9];			/* for evp    */

unsigned
gravy_set(es)
ebuf_struct *es;
{
	double increment, factor, bevelsize, intr, indur, outdur;
	double interval, l_factor, framesize, bevelfact, amp;
	static double linedata[4] = {0., 0., 1., 1.};
	int insamps,outsamps,bevsamps,realsamps,inshift,outshift, newsize;
	int mode, testinsamps;
	long nframes;
	register int j;
	DBENT(gravy_set);
	if(dialog->call(dialog, D_QGRAVY, "") < 1) return 0;
	framesize = dialog->getValue(dialog, 0);
	bevelfact = dialog->getValue(dialog, 1);
	interval = dialog->getValue(dialog, 2);
	l_factor = dialog->getValue(dialog, 3);
	amp = dialog->getValue(dialog, 4);
	mode = dialog->getChoice(dialog, 0);
	if(dialog->getChoice(dialog, 1)) {
		if(get_curve() < 1) return 0;
		clear_events();
	} 
	/* the sampling increment for gravy is determined on the basis of mode,
	since value typed in is either oct. pt., lin. oct., or straight 
	frequency ratio -- the choice is made in the dialog window itself */

	DBPRT(mode);
	switch(mode) {	
	case OCTPT:
		intr = octpch(interval); /* convert interval to lin octave */
		increment = cpsoct(10.0+intr)/cpsoct(10.0);  
		break;
	case LINOCT:
		intr = interval;  	/* interval is already lin octave */
		increment = cpsoct(10.0+interval)/cpsoct(10.0);  
		break;
	case RATIO:
		increment = interval;	/* value is raw ratio already */
		break;
	default:
		{ char msg[60];
		sprintf(msg, "gravy_set:  invalid mode %d.", mode);
		mv_alert(msg);
		}
		return 0;
	}

	indur = (double) es->nsamps/es->srate; /* calculate input dur in secs */
	bevelfact = (bevelfact > 0.5) ? 0.5 : bevelfact;
	bevelsize = framesize * bevelfact;
	evset(framesize,bevelsize,bevelsize,q); /* set up frame shape */
	setline(linedata, 4, SIZE, bevfun);      /* set up bevel function */

	if(!lineset)
	{
		for(j = 0; j < SIZE; j++) array[j] = 1.0;
	}

	indur =  es->nsamps/(double) es->srate; /* input duration */
	DBPRT(indur);
	factor = 1.0/(increment * l_factor);
	DBPRT(factor);
	insamps = framesize * es->srate * increment + 2; /* input framesize */
	if(es->nsamps < insamps*2) {
		mv_alert("Framesize is too large for given duration.");
		return(0);
	}
	DBPRT(framesize);
	DBPRT(insamps);
	bevsamps = bevelsize * es->srate;
	realsamps = insamps - (bevsamps * increment); /* non-overlap samps */
	DBPRT(realsamps);
	inshift = (factor-1) * (double)realsamps - (double)bevsamps * increment;
	inshift -= 2;	/* adjust for interp */
	DBPRT(inshift);
	/* total input frames */
	nframes = (es->nsamps - insamps)/(insamps + inshift) + 1;
	DBPRT(nframes);
	testinsamps = (nframes+1) * (insamps+inshift) + inshift ;
	DBPRT(testinsamps);
	outshift = -bevsamps;
	outsamps = framesize * es->srate;		/* output framesize */
	DBPRT(outsamps);
	outdur = (nframes * (outsamps+outshift))/(double) es->srate + bevelsize;
	DBPRT(outdur);

	/* now load the values into the p array for gravy to use */

	es->p[0] = increment;
	es->p[1] = nframes;
	es->p[2] = outsamps;
	es->p[3] = inshift;
	es->p[4] = outshift;
	es->p[5] = amp;

	newsize = es->bufsize * (outdur/indur);
	DBCOM(original input samps);
	DBPRT(es->nsamps);
	/* what did this do??? */
	/* if(testinsamps > es->nsamps) return 0; */
	/* total samples for all overlapping frames */
	es->nsamps = framesize * nframes * es->srate;
	DBCOM(new output samps);
	DBPRT(es->nsamps);
	tab_set(es);	/* set table for phrase curve */
	DBEXT(gravy_set);

	return (unsigned) newsize; /* return new edit region size, in bytes */
}

mv_gravy(a, b)
cbuf_struct *a;
ebuf_struct *b;
{
	int outsamps,inshift,outshift;
	register int i, k, intt, lgc, ch, j; 
	double z,zz,val;
	double input[4],sig[4],vold[4],old[4],new[4],frac,count, amp;
	double increment, vamp;
	long n,nframes, outcount;
	DBENT(mv_gravy);

	increment = b->p[0];	/* sampling increment for transp */
	nframes = b->p[1];
	outsamps = b->p[2];	/* output framesize */
	inshift = b->p[3];
	outshift = b->p[4];
				/* p[5] is amp factor */

	DBPRT(increment); DBPRT(nframes); DBPRT(outsamps); DBPRT(inshift);
	sfreset();
	outcount = 0;
	z = b->srate/8000;
	z = z ? z : 1;
	zz = z * 2;

	for (n = 0; n < nframes; n++) {	/* loop for all frames */
		j = k = 0;
		DBPRT(n);
		DBPRT(a->inptr);
		DBPRT(b->outptr);
		DBPRT(outcount);
		GETSAMP(a,input);
		for(ch=0; ch<b->nchans; ch++) vold[ch] = input[ch];
		GETSAMP(a,input);
		for(ch=0; ch<b->nchans; ch++) old[ch] = input[ch];
		GETSAMP(a,input);
		for(ch=0; ch<b->nchans; ch++) new[ch] = input[ch];
		intt = lgc = 0;
		frac = count = 0;

		for (i = 0; i < outsamps; i++) {
			while(!j--) {	/* frame envelope */
				val = evp(i,bevfun,bevfun,q);
				j = z;
			}
			while (intt > lgc) {
				GETSAMP(a,input);
				for(ch=0; ch<b->nchans; ch++) {
					vold[ch] = old[ch];
					old[ch] = new[ch];
					new[ch] = input[ch];
				}
				lgc++;
			}
			while(!k--){
				amp = tablei(outcount,array,tabs) * b->p[5];
				k = zz;
			}
			vamp = val * amp;
			for(ch=0; ch<b->nchans; ch++)
				sig[ch] =
				interp(vold[ch],old[ch],new[ch],frac)*vamp;
			ADDSAMP(b, sig);
/*			fprintf(stderr,"inptr %ld outptr %ld outct %ld frac %f vamp %f\n", a->inptr, b->outptr, outcount,frac,vamp); 
			fflush(stderr); */
			outcount++;
			count += increment;
			intt = count;
			frac = count - (double) intt;
		}
		inrepos(a,inshift);	/* reset ptrs. for next frame */
		outrepos(b,outshift);
	}
	DBEXT(mv_gravy);
}

