/*
	graphpoints.c
*/

#include "main.h"
#include "graphpoints.h"
#define GRAPH_HEAD -1234567.89

Graph_points *
new_graphpoints()
{
	Graph_points *g;
	g = (Graph_points *) mv_alloc(sizeof(Graph_points));
	g->nchans = 0;
/* functions */
	g->extendList = gp_extendList;
	g->addPoint = gp_addPoint;
	g->getPoint = gp_getPoint;
	g->previous = gp_previous;
	g->next = gp_next;
	g->last = gp_last;
	g->head = gp_head;
	g->destroy = gp_destroy;
/* initialization */
	g->extendList(g, 4);	/* 4 channels max for now */
	return g;
}

void
gp_destroy(g)
	Graph_points *g;
{
	Pt_link *end, *prev;
	int i;
	for(i = 0; i < g->nchans; i++) {
		for(end=g->last(g, i); end != NULL; ) { 
			prev = end->prev; 
			cfree((char *) end);
			if(!(end = prev))
				break;
		}
	}
	cfree((char *) g->pointlist);
	cfree((char *) g);
	g = (Graph_points *) NULL;
}

int
gp_extendList(g, nchans)
	Graph_points *g;
	int nchans;
{
	char *tmp = (char *) g->pointlist;
	register int i;
	if(!tmp)	/* if not previously allocated */
		tmp = (char *) mv_alloc(sizeof(POINTER)*nchans);
	else if((tmp = (char *) realloc(tmp, sizeof(POINTER) * nchans)) == CNULL) {
		mv_error(errno, "gp_extendList:  unable to allocate.");
		return -1;
	}
	g->pointlist = (Pt_link **) tmp;
	for(i=0; i < nchans; i++)
		g->addPoint(g, i, 0, GRAPH_HEAD); /* flag for uninit. head */
	g->nchans = nchans;
	return 1;
}

Pt_link *
gp_addPoint(g, chan, loc, val)
	Graph_points *g;
	int chan, loc;
	double val;
{
	Pt_link *head = g->pointlist[chan], *point, *new;
	new = (Pt_link *) mv_alloc(sizeof(Pt_link));
	new->xval = loc;
	new->yval = val;
	if(head != (Pt_link *) NULL) {	/* add to existing list */
		point = head;
		while(point->next != (Pt_link *) NULL)
			point = point->next;
		new->prev = point;
		new->next = NULL;
		point->next = new;
	}
	else {	/* set head to values */
		new->prev = NULL;
		new->next = NULL;
		g->pointlist[chan] = new;
	}
	return new;
}

Pt_link *
gp_getPoint(g, chan, loc)	/* returns graphpoint matching chan and loc */
	Graph_points *g;
	int loc, chan;
{
	Pt_link *point, *next;
	for(point=g->pointlist[chan]; point != (Pt_link *) NULL; point = next) {
		next = point->next;
		if(point->xval == loc) return point;
	}
	return point;
}

Pt_link *
gp_previous(g, loc)
	Graph_points *g;
	int loc;
{
	Pt_link *point;
	if((point = g->getPoint(g, loc)) == (Pt_link *) NULL)
		return (Pt_link *) NULL;
	return point->prev;
}

Pt_link *
gp_next(g, loc)
	Graph_points *g;
	int loc;
{
	Pt_link *point;
	if((point = g->getPoint(g, loc)) == (Pt_link *) NULL)
		return (Pt_link *) NULL;
	return point->next;
}

Pt_link *
gp_head(g, chan)
	Graph_points *g;
	int chan;
{
	return g->pointlist[chan];
}

Pt_link *
gp_last(g, chan)
	Graph_points *g;
	int chan;
{
	Pt_link *point, *next;
	for(point=g->pointlist[chan]; point != (Pt_link *) NULL; point = next) {
		if((next = point->next) == NULL)
			return point;
	}
	return (Pt_link *) NULL;
}

Graph_iter *
set_iter(gp, chan, loc)
	Graph_points *gp;
	int chan, loc;
{
	Graph_iter *gi = (Graph_iter *) mv_alloc(sizeof(Graph_iter));
	if(!(gi->current = gp->getPoint(gp, chan, loc))) {
		gi->current = gp->addPoint(gp, chan, 0);
	}
	/* function pointers */
	gi->next = gi_next;
	gi->destroy = gi_destroy;
	return gi;
}

Pt_link *
gi_next(gi)
	Graph_iter *gi;
{
	if(gi->current) {
		Pt_link *tmp = gi->current;
		gi->current = gi->current->next;
		return tmp;
	}
	return 0;
}

void
gi_destroy(gi)
	Graph_iter *gi;
{
	cfree((char *) gi);
	gi = 0;
}

Graph_adder *
set_adder(gp, chan, loc)
	Graph_points *gp;
	int chan, loc;
{
	Graph_adder *ga = (Graph_adder *) mv_alloc(sizeof(Graph_adder));
	ga->current = gp->getPoint(gp, chan, loc);
	/* function pointers */
	ga->add = ga_add;
	ga->destroy = ga_destroy;
	return ga;
}

Pt_link *
ga_add(ga, loc, val)
	Graph_adder *ga;
	int loc;
	double val;
{
	Pt_link *new, *tmp;
	if(!ga->current) mv_die(0, "ga_add: null graph list.");
	tmp = ga->current;
	if(tmp->yval == GRAPH_HEAD) {	/* setting head of list */
		tmp->xval = loc;
		tmp->yval = val;
		tmp->next = NULL;
		tmp->prev = NULL;
	}
	else {
		new = (Pt_link *) mv_alloc(sizeof(Pt_link));
		new->xval = loc;
		new->yval = val;
		tmp->next = new;	/* add new link to list */
		new->prev = tmp;
		new->next = NULL;
		ga->current = new;
	}
	return(ga->current);
}

void
ga_destroy(ga)
	Graph_adder *ga;
{
	cfree((char *) ga);
	ga = NULL;
}
