/* datawin.h */

#define DATAWIN_HEIGHT 356
#define DATAWIN_WIDTH 512
#define DATAPANEL_HEIGHT 100

typedef struct mydatawin {	/* the data-entry window */
	int datawin_number;
	Display *dpy;
	Window frame;
	Mv_screen *scrn;	/* data-entry screen  */
	Mv_panel *dpanel;	/* control panel       */
	Data_buff *data;	/* data buffer */
	char *filename;
	double hmin, hmax; /* data max and min horiz display values */
	double startval, endval, insval; /* screen start, end, hair */
	double edstart, edend;	/* the location of edit points in the data */
	void (*setInsert)();	/* edit routines for selecting regions     */
	void (*setRegion)();
	void (*shiftInsert)(), (*shiftRegion)();
	void (*display)();
	int (*setScanChannels)();	/* inherited from screen object */
	void (*setDataFormat)();
	void (*setHorizValues)(), (*getHorizValues)();
	void (*getScanChannels)();
	void (*setHorizScale)();
	void (*block)();
	void (*unBlock)();
	void (*setFrameLabel)();
	void (*setFileName)();
	char (*(*getFileName)());
	void (*destroy)();
	int (*datawinEvent)();		/* true if evt destined here */
	void (*frameResize)();		/* when wm resizes */
	void (*screen_clear_proc)();  /* button function	*/
	void (*screen_redraw_proc)(); /* button function	*/
	void (*data_fit_proc)();      /* button function	*/
	void (*close_proc)();         /* button function	*/
} Data_win;

/* declarations of functions */
void dw_setInsert();
void dw_setRegion(), dw_shiftInsert(), dw_shiftRegion(), dw_display();
void dw_destroy(), dw_setFrameLabel(), dw_frameResize();
void dw_block(), dw_unBlock(), dw_getScanChannels(), dw_setHorizValues();
void dw_getHorizValues(), dw_setHorizScale();
void dw_setFileName();
char *dw_getFileName();
int dw_datawinEvent(), dw_setScanChannels();
void dw_screen_clear_proc(), dw_close_proc();
void dw_screen_redraw_proc(), dw_data_fit_proc();

Data_win *new_datawin();

Data_win *current_datawin;		/* global to all files */
