#import "parse-header.h"
#include <stdlib.h>
#include <stdio.h>
#include <strings.h>
#import <objc/hashtable.h>

int parse_header(char *header,
                 int header_len,
                 char **fieldbody,
                 char **pattern,
                 int field_count,
                 BOOL unfold)
{
   char *header_buffer;
   int b,i,f_len;
   char *aLine;
   char fieldname[120];
   char *other_buffer;
   char *f_fieldbody;
   BOOL found;
   
   aLine=(char *)malloc((header_len+2)*sizeof(char));
   header_buffer=header;

   while(header_len>0){
      //get one line
      sscanf(header_buffer, "%[^\n]\n",aLine);
      b=strlen(aLine); b++; 
      header_len-=b; header_buffer+=b;
     
      //get header field name
      sscanf(aLine,"%118[^: \t]:",fieldname);
      if(aLine[strlen(fieldname)]!=':')
         continue; //wrong header field

      //lookup starting point of field body and copy it
      other_buffer=aLine;
      other_buffer+=strlen(fieldname)+1;
      while((*other_buffer==(char)32)||(*other_buffer==(char)9))
         other_buffer++;
      f_fieldbody=NXCopyStringBuffer(other_buffer);
      f_len=strlen(f_fieldbody);

      //delete all space between fieldname and ":"
      for(i=strlen(fieldname)-1;i>=0;i--)
         if((fieldname[i]==(char)32)||(fieldname[i]==(char)9))
            fieldname[i]='\0';
         else
            break;

      //lookup field name
      found=NO;
      for(i=0;i<field_count;i++){
         if((fieldbody[i]==(char *)0) && (strcmp(pattern[i],fieldname)==0)){
            //Found! Now get, unfold & copy field body
            char *temp_buffer;
            found=YES;
            while((*header_buffer!='\0') &&
                  ((*header_buffer==(char)32) || (*header_buffer==(char)9))){
               sscanf(header_buffer, "%1024[^\n]\n",aLine);
               b=strlen(aLine); b++; header_len-=b; header_buffer+=b;

               temp_buffer=aLine;
               //forget white-space stuff
               if(unfold)
                  while((*temp_buffer!='\0') &&
                        ((*temp_buffer==(char)32) || (*temp_buffer==(char)9)))
                     temp_buffer++;
               f_fieldbody=(char *)realloc(f_fieldbody, 
                      (f_len+ strlen(temp_buffer)+ 2)*sizeof(char));
               if(unfold)
                  strcat(f_fieldbody," ");
               else
                  strcat(f_fieldbody,"\n");
               strcat(f_fieldbody,temp_buffer);
               f_len=strlen(f_fieldbody);
            }
            fieldbody[i]=f_fieldbody;
            break; 
         }
      }
      if(found==NO)
         free(f_fieldbody);
   }
   free(aLine);
   return 0;
}
