
#import <streams/streams.h>
#import <stdio.h>
#import "mapfile.h"
#import <appkit/NXCType.h>
#import "readline.h"

#define NNTP_LIST_END(s)  ((s)[0]=='.' && ((s)[1]=='\0' || (s)[1]=='\r'))

int MapNntpToStream(FILE *theFile,NXStream *theStream,BOOL echoSocket)
{
   char *buffer;

   while(buffer=readline(theFile),(buffer!=NULL)&&(!NNTP_LIST_END(buffer))){
       int n;
		 
		 n = strlen(buffer);
       if (n >= 2 && buffer[n-1] == '\n' && buffer[n-2] == '\r'){
          buffer[n-2]='\n';
          buffer[n-1]='\0';
          n--;
       }
		 if(*buffer=='.'){
		 	buffer++; //remove byte stuffing
			n--;
		 }
		 
		 if(echoSocket)
		    printf("%s",buffer);

       NXWrite(theStream,buffer,n);
   }
	
	if(echoSocket && (buffer!=NULL) && (NNTP_LIST_END(buffer)))
	   printf("%s",buffer);
		
   if(buffer==NULL)
      return -1;
   return 0;
}
