/*	This file is part of the XText package (version 0.8)
	Mike Dixon, April 1992
	
	Copyright (c) 1992 Xerox Corporation.  All rights reserved.

	Use and copying of this software and preparation of derivative works based
	upon this software are permitted.  This software is made available AS IS,
	and Xerox Corporation makes no warranty about the software or its
	performance.
*/

#import <appkit/Text.h>

/*	XText0 is the 'bare' extensible Text class; it provides the support for
	key bindings, but doesn't provide any of the useful methods you're likely
	to want to bind them to.

	The instance variables are
		nextAction		the action that will interpret the next key
		initialAction	the basic action used to interpret keys (generally
						an XTDispatchAction)
		errorStream		used to report errors

	In normal operation nextAction == initialAction, but an action may
	change nextAction to cause the next key to be interpreted specially.
	For example, this is used to implement ctrl-q (quote next char), and
	could also be used to implement emacs-style prefix maps.

	Most of the methods are all self-explanatory;  the ones that might not
	be are
		newFieldEditorFor:initialAction:estream:
								should be called from a window's delegate's
								getFieldEditor:for: method; returns an XText
								for editing the window's fields
		unboundKey				just beeps
		disableAutodisplay		like setAutodisplay:NO, except that it does
								nothing if this is a field editor (to work
								around a bug in text fields)

	The default initialAction is nil, which just causes all key events to
	be handled by the superclass (i.e. Text).
*/

@interface XText0:Text
{
	id nextAction;
	id initialAction;
	id errorStream;
}
+ newFieldEditorFor:win initialAction:action estream:errs;
- initFrame:(const NXRect *)frameRect text:(const char *)theText
	alignment:(int)mode;
- setErrorStream:errs;
- errorStream;
- setInitialAction:action;
- initialAction;
- setNextAction:action;
- unboundKey;
- disableAutodisplay;
@end
