/*	This file is part of the XText package (version 0.8)
	Mike Dixon, April 1992
	
	Copyright (c) 1992 Xerox Corporation.  All rights reserved.

	Use and copying of this software and preparation of derivative works based
	upon this software are permitted.  This software is made available AS IS,
	and Xerox Corporation makes no warranty about the software or its
	performance.
*/

#import "XText0.h"
#import "XTAction.h"

/*	XText augments XText0 with a bunch of useful methods for emacs-like
	key bindings.

	All of the cursor-movement methods take a 'mode' argument, which may
	be
		0		just move the point to new location
		1		delete to new location
		2		cut to new location
		3		extend selection to new location
	
	The methods are
		goto:end:mode:		implements all movement; second argument specifies
							the other end of the selection when mode != 0
		moveWord:mode:		move n words forward from point (back if n<0)
		moveChar:mode:		move n chars forward from point (back if n<0)
		moveLine:mode:		move n lines down from point (up if n<0)
		lineBegin:			move to beginning of current line
		lineEnd:			move to end of current line
		docBegin:			move to beginning of document
		docEnd:				move to end of document
		collapseSel:		move to beginning of selection (dir<0), end of
							selection (dir>0), or active end of sel (dir=0)
		transChars			transpose characters around point
		openLine			insert new line after point
		scroll::			scroll window n pages + m lines
		scrollIfRO::		scroll window n pages + m lines if doc is
							read-only; returns nil if doc is editable
		insertChar:			inserts the character associated with a key event
		insertNextChar		sets nextAction so that the next key event will be
							interpreted as a character

	When there is a non-empty selection, we keep track of which end is active
	(further movement commands will be relative to that end).  When we move
	up or down lines, we keep track of which column we started in and try to
	stick to it.  XText's instance variables are used to implement this
	behavior:
		posHint		the cp of the point; if this doesn't correspond to either
					end of the selection, we put the point after the selection
		xHint		the column we're trying to keep the point in during
					vertical movement
		xHintPos	xHint is only valid if this is the cp of the point
	("cp" == character position)

	This file also includes initbase_emacs, called by XTDispatchAction's
	initBase:estream: method when base == "emacs" to set up the default
	key bindings.
*/

@interface XText:XText0
{
	int posHint;
	int xHint;		// note that this is in characters, not pixels
	int xHintPos;
}
- goto:(int)pos end:(int)end mode:(int)mode;
- moveWord:(int)cnt mode:(int)mode;
- moveChar:(int)cnt mode:(int)mode;
- moveLine:(int)cnt mode:(int)mode;
- lineBegin:(int)mode;
- lineEnd:(int)mode;
- docBegin:(int)mode;
- docEnd:(int)mode;
- collapseSel:(int)dir;
- transChars;
- openLine;
- scroll:(int)pages :(int)lines;
- scrollIfRO:(int)pages :(int)lines;
- insertChar:(NXEvent *)event;
- insertNextChar;
@end

void initbase_emacs(actionTbl actions, NXZone *zone);