/*	This file is part of the XText package (version 0.8)
	Mike Dixon, April 1992
	
	Copyright (c) 1992 Xerox Corporation.  All rights reserved.

	Use and copying of this software and preparation of derivative works based
	upon this software are permitted.  This software is made available AS IS,
	and Xerox Corporation makes no warranty about the software or its
	performance.
*/

#import "XTScroller.h"
#import "XText.h"

@implementation XTScroller

- initFrame:(const NXRect *)frameRect
{
    NXRect rect = {0.0, 0.0, 0.0, 0.0};
    NXSize s = {1.0E38, 1.0E38};
	id my_xtext;
	
    // this is mostly cribbed from the TextLab example
	// it's hard to believe that it needs to be this complicated

    [super initFrame:frameRect];
	[self setBorderType:NX_BEZEL];
    [[self setVertScrollerRequired:YES] setHorizScrollerRequired:NO];
	
    [self getContentSize:&(rect.size)];
    my_xtext = [[XText alloc] initFrame:&rect];
	[my_xtext setOpaque:YES];
    [my_xtext notifyAncestorWhenFrameChanged:YES];
	[my_xtext setVertResizable:YES];
	[my_xtext setHorizResizable:NO];
	[my_xtext setMonoFont:NO];
	[my_xtext setDelegate:self];
    
    [my_xtext setMinSize:&(rect.size)];
    [my_xtext setMaxSize:&s];
    [my_xtext setAutosizing:NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];
    
    [my_xtext setCharFilter:NXEditorFilter];

    [self setDocView:my_xtext];
    [my_xtext setSel:0 :0];	
    
    [contentView setAutoresizeSubviews:YES];
    [contentView setAutosizing:NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];

    return self;
}

@end
