/*	This file is part of the XText package (version 0.8)
	Mike Dixon, April 1992
	
	Copyright (c) 1992 Xerox Corporation.  All rights reserved.

	Use and copying of this software and preparation of derivative works based
	upon this software are permitted.  This software is made available AS IS,
	and Xerox Corporation makes no warranty about the software or its
	performance.
*/

#import <objc/Object.h>
#import <dpsclient/event.h>

/*	An XTAction specifies the action to be taken in response to a key event.
	When a key event occurs, the applyTo:event: method is invoked; this is
	the key method that must be implemented by the subclasses of XTAction.

	Actions normally return self from the applyTo:event: method, but by
	returning nil they can cause the event to be handled normally by XText0's
	superclass (i.e. Text).

	The class method undefinedAction returns a default action that invokes
	the text object's unboundKey method.
*/

@interface XTAction:Object
{
}
+ undefinedAction;
- applyTo:xtext event:(NXEvent *)event;
@end

#define MAPPED_KEYS      243				//	table size for a dispatch action
#define KEY_CODES  (MAPPED_KEYS * 16)	//	4 modifiers = 16 combinations/key

/* keyCodes are 16 * event->data.key.keyCode,
		+ 1 if control,
		+ 2 if shift,
		+ 4 if alt,
		+ 8 if command
*/

typedef int keyCode;
typedef XTAction *actionTbl[KEY_CODES];

/*	XTMsg0Action, XTMsg1Action, and XTMsg2Action are subclasses of XTAction
	that send a specified message to the text object with 0, 1, or 2 args.
*/

@interface XTMsg0Action:XTAction
{
	SEL	action_sel;
}
- initSel:(SEL)sel;
@end

@interface XTMsg1Action:XTAction
{
	SEL	action_sel;
	int action_arg;
}
- initSel:(SEL)sel arg:(int)arg;
@end

@interface XTMsg2Action:XTAction
{
	SEL	action_sel;
	int action_arg1;
	int action_arg2;
}
- initSel:(SEL)sel arg:(int)arg1 arg:(int)arg2;
@end

/*	XTDispatchAction is a subclass of XTAction that maintains a dispatch
	table of other actions and selects one based on the key pressed.  The
	methods are
		initBase:estream:	the first argument is a string naming a 'base'
							set of initial bindings; the only values currently
							supported are "emacs" and "none"
		bindKey:toAction:estream:
							bind a key to a specified action; an action of nil
							will cause the key to be handled normally by the
							Text class
		addBindings:estream:
							parse and install the bindings specified by a
							string

	The estream argument is used to report any errors; if it is nil, the
	default error stream (which simply pops up an alert panel) is used.
*/

@interface XTDispatchAction:XTAction
{
	actionTbl actions;
}
- initBase:(const char *)base estream:errs;
- bindKey:(keyCode)key toAction:action estream:errs;
@end

@interface XTDispatchAction(parsing)
- addBindings:(const char *)bindings estream:errs;
@end

/*	XTEventMsgAction is a subclass of XTAction that sends a specified
	message to the text object, passing the event as an argument.
	This is useful for implementing some special-purpose prefix commands
	like 'quote next character'
*/

@interface XTEventMsgAction:XTAction
{
	SEL action_sel;
}
- initSel:(SEL)sel;
@end

/*	XTSeqAction is a subclass of XTAction that invokes a sequence of
	subactions.
*/

@interface XTSeqAction:XTAction
{
	int length;
	XTAction **actions;
}
- initLength:(int)len actions:(XTAction **)acts;
@end
