/*	This file is part of the XText package (version 0.8)
	Mike Dixon, April 1992
	
	Copyright (c) 1992 Xerox Corporation.  All rights reserved.

	Use and copying of this software and preparation of derivative works based
	upon this software are permitted.  This software is made available AS IS,
	and Xerox Corporation makes no warranty about the software or its
	performance.
*/

#import "ErrorStream.h"
#import <appkit/Application.h>
#import <appkit/Panel.h>
#import <stdio.h>

@implementation ErrorStream

static id default_error_stream = 0;

+ default
{
	if (!default_error_stream)
		default_error_stream = [[ErrorStream allocFromZone:[NXApp zone]] init];
	return default_error_stream;
}

- report: (const STR) msg
{
	NXRunAlertPanel("Error", "%s", 0, 0, 0, msg);
	return self;
}

@end
