/*	This file is part of the XText package (version 0.8)
	Mike Dixon, April 1992
	
	Copyright (c) 1992 Xerox Corporation.  All rights reserved.

	Use and copying of this software and preparation of derivative works based
	upon this software are permitted.  This software is made available AS IS,
	and Xerox Corporation makes no warranty about the software or its
	performance.
*/

#import <objc/Object.h>

/*  The ErrorStream class allows clients of XText to customize its error
	handling.  All errors are reported by invoking the report: method on
	a client-supplied ErrorStream.  The default implementation simply puts
	the message up in a modal panel, but you can create subclasses that do
	more interesting things if you like.

	By default, all instances of XText share a single instance of ErrorStream,
	which can be obtained by calling [ErrorStream default].
*/

@interface ErrorStream:Object
{
}
+ default;
- report: (const STR) msg;
@end

