#import <appkit/appkit.h>
#import "TextKeyDown.h"

@implementation TextKeyDown 

- initFrame:(const NXRect *)aRect
{
   NXSize size;
   NXSize s = {1.0E38, 1.0E38};
  
   [super initFrame:aRect];
   [[[self superview] superview] getContentSize:&size];
   [[self superview] setAutoresizeSubviews:YES];


   [self sizeTo:size.width :size.height];
   [self setEditable:NO];
   [self setMonoFont:NO];
   [self setBackgroundGray:NX_WHITE];
   [self setOpaque:YES];
   [self notifyAncestorWhenFrameChanged: YES];
   [self setVertResizable:YES];
	[self setHorizResizable:NO];
	
	[self setMinSize:&size];
	[self setMaxSize:&s];
	[[self superview] setAutoresizeSubviews:YES];
   [[self superview] setAutosizing:NX_HEIGHTSIZABLE | NX_WIDTHSIZABLE];

   return self;
}

- keyDown:(NXEvent *)theEvent
{
   int cCode=theEvent->data.key.charCode;

   if(![self isEditable])
      if(((cCode>171)&&(cCode<176))||(cCode==32))
         [nextResponder keyDown:theEvent];
      else
		   NXBeep();
	else
      [super keyDown:theEvent];
	
   return self;
}

@end
